/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.gadp.client.GadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpValueUtils;
import ghidra.dbg.gadp.client.annot.GadpEventHandler;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import java.util.List;

public interface GadpClientTargetEventScope
extends GadpClientTargetObject,
TargetEventScope {
    @GadpEventHandler(value=Gadp.EventNotification.EvtCase.TARGET_EVENT)
    default public void handleDebuggerEvent(Gadp.EventNotification notification) {
        Gadp.TargetEvent evt = notification.getTargetEvent();
        Gadp.Path threadPath = evt.getEventThread();
        TargetThread thread = threadPath == null || threadPath.getECount() == 0 ? null : (TargetThread)this.getModel().getProxy((List<String>)threadPath.getEList(), true).as(TargetThread.class);
        TargetEventScope.TargetEventType type = GadpValueUtils.getTargetEventType(evt.getType());
        String description = evt.getDescription();
        List<Object> parameters = GadpValueUtils.getValues((DebuggerObjectModel)this.getModel(), evt.getParametersList());
        ((DebuggerModelListener)this.getDelegate().getListeners().fire).event((TargetObject)this, thread, type, description, parameters);
    }
}

