/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainFileProxy;
import ghidra.framework.data.DomainObjectChangeSupport;
import ghidra.framework.data.GhidraFile;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventQueueID;
import ghidra.framework.model.UserData;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.LockException;
import ghidra.util.Lock;
import ghidra.util.classfinder.ClassSearcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DomainObjectAdapter
implements DomainObject {
    protected static final String DEFAULT_NAME = "untitled";
    private static Class<?> defaultDomainObjClass;
    private static HashMap<String, ContentHandler> contentHandlerTypeMap;
    private static HashMap<Class<?>, ContentHandler> contentHandlerClassMap;
    private static ChangeListener contentHandlerUpdateListener;
    protected String name;
    private DomainFile domainFile;
    private DomainObjectChangeSupport docs;
    protected Map<EventQueueID, DomainObjectChangeSupport> changeSupportMap = new ConcurrentHashMap<EventQueueID, DomainObjectChangeSupport>();
    private volatile boolean eventsEnabled = true;
    private Set<DomainObjectClosedListener> closeListeners = new CopyOnWriteArraySet<DomainObjectClosedListener>();
    private ArrayList<Object> consumers;
    protected Map<String, String> metadata = new LinkedHashMap<String, String>();
    protected boolean changed = false;
    protected boolean temporary = false;
    protected Lock lock = new Lock("Domain Object");
    private long modificationNumber = 1L;

    protected DomainObjectAdapter(String name, int timeInterval, Object consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Consumer must not be null");
        }
        this.name = name;
        this.docs = new DomainObjectChangeSupport(this, timeInterval, this.lock);
        this.consumers = new ArrayList();
        this.consumers.add(consumer);
        if (!UserData.class.isAssignableFrom(this.getClass())) {
            this.domainFile = new DomainFileProxy(name, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Object consumer) {
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            if (!this.consumers.remove(consumer)) {
                throw new IllegalArgumentException("Attempted to release domain object with unknown consumer: " + consumer);
            }
            if (this.consumers.size() != 0) {
                return;
            }
        }
        this.close();
    }

    public Lock getLock() {
        return this.lock;
    }

    @Override
    public DomainFile getDomainFile() {
        return this.domainFile;
    }

    protected FileSystem getAssociatedUserFilesystem() {
        if (this.domainFile instanceof GhidraFile) {
            return ((GhidraFile)this.domainFile).getUserFileSystem();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        String classname = this.getClass().getName();
        classname = classname.substring(classname.lastIndexOf(46));
        return this.name + " - " + classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String newName) {
        DomainObjectAdapter domainObjectAdapter = this;
        synchronized (domainObjectAdapter) {
            if (this.name.equals(newName)) {
                return;
            }
            this.name = newName;
            this.changed = true;
        }
        this.fireEvent(new DomainObjectChangeRecord(3));
    }

    private void clearDomainObj() {
        if (this.domainFile instanceof GhidraFile) {
            GhidraFile file = (GhidraFile)this.domainFile;
            file.clearDomainObj();
        } else if (this.domainFile instanceof DomainFileProxy) {
            DomainFileProxy df = (DomainFileProxy)this.domainFile;
            df.clearDomainObj();
        }
    }

    @Override
    public boolean isChanged() {
        return this.changed && !this.temporary;
    }

    @Override
    public void setTemporary(boolean state) {
        this.temporary = state;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    protected void setDomainFile(DomainFile df) {
        if (df == null) {
            throw new IllegalArgumentException("DomainFile must not be null");
        }
        this.clearDomainObj();
        DomainFile oldDf = this.domainFile;
        this.domainFile = df;
        this.fireEvent(new DomainObjectChangeRecord(2, oldDf, df));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        DomainObjectAdapter domainObjectAdapter = this;
        synchronized (domainObjectAdapter) {
            this.clearDomainObj();
        }
        this.docs.dispose();
        for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
            queue.dispose();
        }
        this.notifyCloseListeners();
    }

    private void notifyCloseListeners() {
        for (DomainObjectClosedListener listener : this.closeListeners) {
            listener.domainObjectClosed();
        }
        this.closeListeners.clear();
    }

    @Override
    public void flushEvents() {
        this.docs.flush();
        for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
            queue.flush();
        }
    }

    public boolean getChangeStatus() {
        return this.changed;
    }

    @Override
    public void addListener(DomainObjectListener l) {
        this.docs.addListener(l);
    }

    @Override
    public void removeListener(DomainObjectListener l) {
        this.docs.removeListener(l);
    }

    @Override
    public void addCloseListener(DomainObjectClosedListener listener) {
        this.closeListeners.add(listener);
    }

    @Override
    public void removeCloseListener(DomainObjectClosedListener listener) {
        this.closeListeners.remove(listener);
    }

    @Override
    public EventQueueID createPrivateEventQueue(DomainObjectListener listener, int maxDelay) {
        EventQueueID eventQueueID = new EventQueueID();
        DomainObjectChangeSupport queue = new DomainObjectChangeSupport(this, maxDelay, this.lock);
        queue.addListener(listener);
        this.changeSupportMap.put(eventQueueID, queue);
        return eventQueueID;
    }

    @Override
    public boolean removePrivateEventQueue(EventQueueID id) {
        DomainObjectChangeSupport queue = this.changeSupportMap.remove(id);
        if (queue == null) {
            return false;
        }
        queue.dispose();
        return true;
    }

    @Override
    public void flushPrivateEventQueue(EventQueueID id) {
        DomainObjectChangeSupport queue = this.changeSupportMap.get(id);
        if (queue != null) {
            queue.flush();
        }
    }

    @Override
    public abstract String getDescription();

    public void fireEvent(DomainObjectChangeRecord ev) {
        ++this.modificationNumber;
        if (this.eventsEnabled) {
            this.docs.fireEvent(ev);
            for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
                queue.fireEvent(ev);
            }
        }
    }

    @Override
    public void setEventsEnabled(boolean v) {
        if (this.eventsEnabled != v) {
            this.eventsEnabled = v;
            if (this.eventsEnabled) {
                DomainObjectChangeRecord docr = new DomainObjectChangeRecord(4);
                this.docs.fireEvent(docr);
                for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
                    queue.fireEvent(docr);
                }
            }
        }
    }

    @Override
    public boolean isSendingEvents() {
        return this.eventsEnabled;
    }

    @Override
    public boolean hasExclusiveAccess() {
        return this.domainFile == null || !this.domainFile.isCheckedOut() || this.domainFile.isCheckedOutExclusive();
    }

    public void checkExclusiveAccess() throws LockException {
        if (!this.hasExclusiveAccess()) {
            throw new LockException();
        }
    }

    protected void setChanged(boolean state) {
        this.changed = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addConsumer(Object consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Consumer must not be null");
        }
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            if (this.isClosed()) {
                return false;
            }
            if (this.consumers.contains(consumer)) {
                throw new IllegalArgumentException("Attempted to acquire the domain object more than once by the same consumer: " + consumer);
            }
            this.consumers.add(consumer);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasConsumers() {
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            return this.consumers.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUsedExclusivelyBy(Object consumer) {
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            return this.consumers.size() == 1 && this.consumers.contains(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsedBy(Object consumer) {
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            return this.consumers.contains(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Object> getConsumerList() {
        ArrayList<Object> arrayList = this.consumers;
        synchronized (arrayList) {
            return new ArrayList<Object>(this.consumers);
        }
    }

    public static synchronized void setDefaultContentClass(Class<?> doClass) {
        defaultDomainObjClass = doClass;
        if (contentHandlerTypeMap != null) {
            if (doClass == null) {
                contentHandlerTypeMap.remove(null);
            } else {
                ContentHandler ch = contentHandlerClassMap.get(doClass);
                if (ch != null) {
                    contentHandlerTypeMap.put(null, ch);
                }
            }
        }
    }

    static synchronized ContentHandler getContentHandler(String contentType) throws IOException {
        DomainObjectAdapter.checkContentHandlerMaps();
        ContentHandler ch = contentHandlerTypeMap.get(contentType);
        if (ch == null) {
            throw new IOException("Content handler not found for " + contentType);
        }
        return ch;
    }

    public static synchronized ContentHandler getContentHandler(DomainObject dobj) throws IOException {
        DomainObjectAdapter.checkContentHandlerMaps();
        ContentHandler ch = contentHandlerClassMap.get(dobj.getClass());
        if (ch == null) {
            throw new IOException("Content handler not found for " + dobj.getClass().getName());
        }
        return ch;
    }

    private static void checkContentHandlerMaps() {
        if (contentHandlerTypeMap != null) {
            return;
        }
        DomainObjectAdapter.getContentHandlers();
        ClassSearcher.addChangeListener((ChangeListener)contentHandlerUpdateListener);
    }

    private static synchronized void getContentHandlers() {
        contentHandlerClassMap = new HashMap();
        contentHandlerTypeMap = new HashMap();
        List handlers = ClassSearcher.getInstances(ContentHandler.class);
        for (ContentHandler ch : handlers) {
            String type = ch.getContentType();
            Class<? extends DomainObject> DOClass = ch.getDomainObjectClass();
            if (type == null || DOClass == null) continue;
            contentHandlerClassMap.put(DOClass, ch);
            contentHandlerTypeMap.put(type, ch);
        }
        DomainObjectAdapter.setDefaultContentClass(defaultDomainObjClass);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public long getModificationNumber() {
        return this.modificationNumber;
    }

    protected void fatalErrorOccurred(Exception e) {
        this.docs.fatalErrorOccurred(e);
        for (DomainObjectChangeSupport queue : this.changeSupportMap.values()) {
            queue.fatalErrorOccurred(e);
        }
        throw new DomainObjectException(e);
    }

    static {
        contentHandlerUpdateListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DomainObjectAdapter.getContentHandlers();
            }
        };
    }
}

