/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.main.datatree.DomainFolderRootNode;
import ghidra.framework.main.datatree.ProjectDataTreePanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ChangeManager
implements DomainFolderChangeListener {
    private DomainFolderRootNode root;
    private ProjectDataTreePanel treePanel;
    private DataTree tree;

    ChangeManager(ProjectDataTreePanel treePanel) {
        this.treePanel = treePanel;
        this.tree = treePanel.getDataTree();
        this.root = (DomainFolderRootNode)this.tree.getModelRoot();
    }

    @Override
    public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
        this.updateFolderNode(parent);
        DomainFolderNode folderNode = this.findDomainFolderNode(parent, true);
        if (folderNode == null) {
            return;
        }
        List children = folderNode.getChildren();
        for (GTreeNode child : children) {
            if (!(child instanceof DomainFileNode) || !child.getName().equals(name)) continue;
            folderNode.removeNode(child);
        }
    }

    @Override
    public void domainFolderRemoved(DomainFolder parent, String name) {
        this.updateFolderNode(parent);
        ArrayList<String> folderPath = new ArrayList<String>();
        this.getFolderPath(parent, folderPath);
        folderPath.add(name);
        DomainFolderNode folderNode = this.findDomainFolderNode(folderPath, true);
        if (folderNode != null) {
            folderNode.getParent().removeNode((GTreeNode)folderNode);
        }
    }

    @Override
    public void domainFolderRenamed(DomainFolder folder, String oldName) {
        this.domainFolderRemoved(folder.getParent(), oldName);
        this.domainFolderAdded(folder);
    }

    @Override
    public void domainFileRenamed(DomainFile file, String oldName) {
        this.domainFileRemoved(file.getParent(), oldName, file.getFileID());
        this.domainFileAdded(file);
    }

    @Override
    public void domainFolderMoved(DomainFolder folder, DomainFolder oldParent) {
        this.domainFolderRemoved(oldParent, folder.getName());
        this.domainFolderAdded(folder);
    }

    @Override
    public void domainFileMoved(DomainFile file, DomainFolder oldParent, String oldName) {
        this.updateFolderNode(oldParent);
        this.domainFileAdded(file);
    }

    @Override
    public void domainFileAdded(DomainFile file) {
        DomainFileNode domainFileNode = this.findDomainFileNode(file, true);
        if (domainFileNode != null) {
            return;
        }
        DomainFolder parent = file.getParent();
        DomainFolderNode folderNode = this.findDomainFolderNode(parent, true);
        if (folderNode != null && folderNode.isLoaded()) {
            DomainFileNode newNode = new DomainFileNode(file);
            ChangeManager.addNode((GTreeNode)folderNode, newNode);
        }
    }

    static void addNode(GTreeNode parentNode, GTreeNode newNode) {
        List allChildren = parentNode.getChildren();
        int index = Collections.binarySearch(allChildren, newNode);
        if (index < 0) {
            index = -index - 1;
        }
        parentNode.addNode(index, newNode);
    }

    @Override
    public void domainFolderAdded(DomainFolder folder) {
        DomainFolderNode domainFolderNode = this.findDomainFolderNode(folder, true);
        if (domainFolderNode != null) {
            return;
        }
        DomainFolder parentFolder = folder.getParent();
        DomainFolderNode folderNode = this.findDomainFolderNode(parentFolder, true);
        if (folderNode != null && folderNode.isLoaded()) {
            DomainFolderNode newNode = new DomainFolderNode(folder, folderNode.getDomainFileFilter());
            ChangeManager.addNode((GTreeNode)folderNode, (GTreeNode)newNode);
        }
    }

    @Override
    public void domainFolderSetActive(DomainFolder folder) {
        DomainFolderNode folderNode = this.findDomainFolderNode(folder, false);
        if (folderNode != null) {
            this.tree.setSelectedNode((GTreeNode)folderNode);
        }
    }

    @Override
    public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
        DomainFileNode fileNode = this.findDomainFileNode(file, true);
        if (fileNode != null) {
            fileNode.refresh();
        }
        this.treePanel.domainChange();
    }

    private void getFolderPath(DomainFolder df, List<String> list) {
        DomainFolder parent = df.getParent();
        if (parent != null) {
            this.getFolderPath(parent, list);
            list.add(df.getName());
        }
    }

    private DomainFolderNode findDomainFolderNode(DomainFolder df, boolean lazy) {
        ArrayList<String> folderPath = new ArrayList<String>();
        this.getFolderPath(df, folderPath);
        return this.findDomainFolderNode(folderPath, lazy);
    }

    private DomainFolderNode findDomainFolderNode(List<String> folderPath, boolean lazy) {
        DomainFolderNode folderNode = this.root;
        for (String name : folderPath) {
            if (lazy && !folderNode.isLoaded()) {
                return null;
            }
            boolean found = false;
            for (GTreeNode node : folderNode.getChildren()) {
                if (!(node instanceof DomainFolderNode) || !name.equals(node.getName())) continue;
                folderNode = (DomainFolderNode)node;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return folderNode;
    }

    private DomainFileNode findDomainFileNode(DomainFile domainFile, boolean lazy) {
        DomainFolderNode folderNode = this.findDomainFolderNode(domainFile.getParent(), lazy);
        if (folderNode == null) {
            return null;
        }
        if (lazy && !folderNode.isLoaded()) {
            return null;
        }
        GTreeNode child = folderNode.getChild(domainFile.getName());
        if (child instanceof DomainFileNode) {
            return (DomainFileNode)child;
        }
        return null;
    }

    private void updateFolderNode(DomainFolder parent) {
        DomainFolderNode folderNode = this.findDomainFolderNode(parent, true);
        if (folderNode == null) {
            return;
        }
        DomainFolder folder = folderNode.getDomainFolder();
        List children = folderNode.getChildren();
        for (GTreeNode child : children) {
            if (child instanceof DomainFileNode) {
                if (folder.getFile(child.getName()) != null) continue;
                folderNode.removeNode(child);
                continue;
            }
            if (!(child instanceof DomainFolderNode) || folder.getFolder(child.getName()) != null) continue;
            folderNode.removeNode(child);
        }
    }

    @Override
    public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
    }

    @Override
    public void domainFileObjectOpenedForUpdate(DomainFile file, DomainObject object) {
    }

    @Override
    public void domainFileObjectClosed(DomainFile file, DomainObject object) {
    }
}

