/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.util;

import ghidra.MiscellaneousPluginPackage;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public abstract class PluginPackage
implements ExtensionPoint,
Comparable<PluginPackage> {
    public static final int UTILITY_PRIORITY = 0;
    public static final int CORE_PRIORITY = 1;
    public static final int FEATURE_PRIORITY = 4;
    public static final int MISCELLANIOUS_PRIORITY = 6;
    public static final int DEVELOPER_PRIORITY = 8;
    public static final int EXAMPLES_PRIORITY = 10;
    public static final int EXPERIMENTAL_PRIORITY = 12;
    private static Map<String, PluginPackage> packageMap;
    private final String name;
    private final Icon icon;
    private final String description;
    private final int priority;

    public static PluginPackage getPluginPackage(String packageName) {
        PluginPackage pluginPackage;
        if (packageMap == null) {
            packageMap = PluginPackage.createPackageMap();
        }
        if ((pluginPackage = packageMap.get(packageName.toLowerCase())) == null) {
            Msg.warn(PluginPackage.class, (Object)("Can't find plugin package for " + packageName + "! Creating stub..."));
            pluginPackage = packageMap.get("Miscellaneous".toLowerCase());
        }
        return pluginPackage;
    }

    private static Map<String, PluginPackage> createPackageMap() {
        HashMap<String, PluginPackage> map = new HashMap<String, PluginPackage>();
        List classes = ClassSearcher.getClasses(PluginPackage.class);
        for (Class class1 : classes) {
            try {
                PluginPackage pluginPackage = (PluginPackage)class1.newInstance();
                String name = pluginPackage.getName().toLowerCase();
                if (map.containsKey(name)) {
                    Msg.error(PluginPackage.class, (Object)("PluginPackage already exist for name: " + name));
                    continue;
                }
                map.put(name, pluginPackage);
            }
            catch (Exception e) {
                Msg.error(PluginPackage.class, (Object)("Could not instantiate " + class1.getName()), (Throwable)e);
            }
        }
        map.put("Miscellaneous".toLowerCase(), new MiscellaneousPluginPackage());
        return map;
    }

    protected PluginPackage(String name, Icon icon, String description) {
        this(name, icon, description, 4);
    }

    protected PluginPackage(String name, Icon icon, String description, int priority) {
        this.name = name;
        this.icon = icon;
        this.description = description;
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public PluginStatus getActivationLevel() {
        return PluginStatus.RELEASED;
    }

    @Override
    public int compareTo(PluginPackage other) {
        if (this.priority == other.priority) {
            return this.name.compareTo(other.name);
        }
        return this.priority - other.priority;
    }

    public String toString() {
        return this.name;
    }
}

