/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbModuleSection;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetModule;
import agent.gdb.model.impl.GdbModelTargetSection;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSectionContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="SectionContainer", attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetSectionContainer
extends DefaultTargetObject<GdbModelTargetSection, GdbModelTargetModule>
implements TargetSectionContainer {
    public static final String NAME = "Sections";
    protected final GdbModelImpl impl;
    protected final GdbModelTargetModule module;

    public GdbModelTargetSectionContainer(GdbModelTargetModule module) {
        super((AbstractDebuggerObjectModel)module.impl, (TargetObject)module, NAME, "SectionContainer");
        this.impl = module.impl;
        this.module = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUsingSections(Map<String, GdbModuleSection> byName) {
        List sections;
        GdbModelTargetSectionContainer gdbModelTargetSectionContainer = this;
        synchronized (gdbModelTargetSectionContainer) {
            sections = byName.values().stream().filter(s -> s.getAttributes().contains("ALLOC")).map(this::getTargetSection).collect(Collectors.toList());
        }
        this.setElements(sections, "Refreshed");
        ((GdbModelTargetModule)this.parent).sectionsRefreshed();
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.module.module.listSections().thenAccept(this::updateUsingSections);
    }

    protected synchronized GdbModelTargetSection getTargetSection(GdbModuleSection section) {
        TargetObject modelObject = this.impl.getModelObject(section);
        if (modelObject != null) {
            return (GdbModelTargetSection)modelObject;
        }
        return new GdbModelTargetSection(this, this.module, section);
    }
}

