/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.EventTrigger;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.AddressCollectors;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceSpan;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Set;

public class DebuggerStaticSyncTrait {
    protected static final AutoConfigState.ClassHandler<DebuggerStaticSyncTrait> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerStaticSyncTrait.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected ToggleDockingAction actionAutoSyncCursorWithStaticListing;
    protected ToggleDockingAction actionAutoSyncSelectionWithStaticListing;
    protected DockingAction actionSyncSelectionIntoStaticListing;
    protected DockingAction actionSyncSelectionFromStaticListing;
    @AutoConfigStateField
    private boolean autoSyncCursorWithStaticListing;
    @AutoConfigStateField
    private boolean autoSyncSelectionWithStaticListing;
    private final PluginTool tool;
    private final Plugin plugin;
    private final ComponentProvider provider;
    private final boolean isAutoSyncAllowed;
    private DebuggerStaticMappingService mappingService;
    private final AutoService.Wiring autoServiceWiring;
    private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private ProgramLocation currentDynamicLocation;
    private ProgramSelection currentDynamicSelection;
    private Program currentStaticProgram;
    private ProgramLocation currentStaticLocation;
    private ProgramSelection currentStaticSelection;
    protected final ForStaticSyncMappingChangeListener mappingChangeListener = new ForStaticSyncMappingChangeListener();

    private static boolean dynamicHasSelection(ProgramLocationActionContext ctx) {
        if (ctx == null) {
            return false;
        }
        ProgramSelection sel = ctx.getSelection();
        return sel != null && !sel.isEmpty();
    }

    public DebuggerStaticSyncTrait(PluginTool tool, Plugin plugin, ComponentProvider provider, boolean isAutoSyncAllowed) {
        this.tool = tool;
        this.plugin = plugin;
        this.provider = provider;
        this.isAutoSyncAllowed = isAutoSyncAllowed;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.autoSyncCursorWithStaticListing = isAutoSyncAllowed;
        this.autoSyncSelectionWithStaticListing = isAutoSyncAllowed;
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        if (this.mappingService != null) {
            this.mappingService.removeChangeListener(this.mappingChangeListener);
        }
        this.mappingService = mappingService;
        if (this.mappingService != null) {
            this.mappingService.addChangeListener(this.mappingChangeListener);
            this.doAutoSyncCursorIntoStatic(this.currentDynamicLocation);
        }
    }

    public ToggleDockingAction installAutoSyncCursorWithStaticListingAction() {
        this.actionAutoSyncCursorWithStaticListing = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.AutoSyncCursorWithStaticListingAction.builder(this.plugin).enabled(true)).selected(true).onAction(ctx -> this.doSetAutoSyncCursorWithStaticListing(this.actionAutoSyncCursorWithStaticListing.isSelected()))).buildAndInstallLocal(this.provider);
        return this.actionAutoSyncCursorWithStaticListing;
    }

    public ToggleDockingAction installAutoSyncSelectionWithStaticListingAction() {
        this.actionAutoSyncSelectionWithStaticListing = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.AutoSyncSelectionWithStaticListingAction.builder(this.plugin).enabled(true)).selected(true).onAction(ctx -> this.doSetAutoSyncSelectionWithStaticListing(this.actionAutoSyncSelectionWithStaticListing.isSelected()))).buildAndInstallLocal(this.provider);
        return this.actionAutoSyncSelectionWithStaticListing;
    }

    public DockingAction installSyncSelectionIntoStaticListingAction() {
        this.actionSyncSelectionIntoStaticListing = (DockingAction)DebuggerResources.SyncSelectionIntoStaticListingAction.builder(this.plugin).withContext(ProgramLocationActionContext.class).enabledWhen(ctx -> DebuggerStaticSyncTrait.dynamicHasSelection(ctx)).onAction(this::activatedSyncSelectionIntoStatic).buildAndInstallLocal(this.provider);
        return this.actionSyncSelectionIntoStaticListing;
    }

    public DockingAction installSyncSelectionFromStaticListingAction() {
        this.actionSyncSelectionFromStaticListing = (DockingAction)DebuggerResources.SyncSelectionFromStaticListingAction.builder(this.plugin).withContext(ProgramLocationActionContext.class).enabledWhen(ctx -> this.staticHasSelection((ActionContext)ctx)).onAction(this::activatedSyncSelectionFromStatic).buildAndInstallLocal(this.provider);
        return this.actionSyncSelectionFromStaticListing;
    }

    private boolean staticHasSelection(ActionContext ctx) {
        return this.currentStaticSelection != null && !this.currentStaticSelection.isEmpty();
    }

    protected void activatedSyncSelectionIntoStatic(ProgramLocationActionContext ctx) {
        ProgramSelection result = this.doSyncSelectionIntoStatic(ctx.getProgram(), ctx.getSelection());
        if (result != null && result.isEmpty()) {
            this.displayMapError("the dynamic view", "the static listing");
        }
    }

    protected void activatedSyncSelectionFromStatic(ActionContext ctx) {
        ProgramSelection result = this.doSyncSelectionFromStatic();
        if (result != null && result.isEmpty()) {
            this.displayMapError("the static listing", "the dynamic view");
        }
    }

    protected void doSyncCursorIntoStatic(ProgramLocation location) {
        if (location == null || this.mappingService == null) {
            return;
        }
        ProgramLocation staticLoc = this.mappingService.getStaticLocationFromDynamic(location);
        if (staticLoc == null) {
            return;
        }
        this.staticGoTo(staticLoc);
    }

    protected void doSyncCursorFromStatic() {
        TraceProgramView view = this.current.getView();
        if (this.currentStaticLocation == null || view == null || this.mappingService == null) {
            return;
        }
        ProgramLocation dynamicLoc = this.mappingService.getDynamicLocationFromStatic(view, this.currentStaticLocation);
        if (dynamicLoc == null) {
            return;
        }
        this.dynamicGoTo(dynamicLoc);
    }

    public void doAutoSyncCursorIntoStatic(ProgramLocation location) {
        if (!this.isAutoSyncCursorWithStaticListing()) {
            return;
        }
        this.doSyncCursorIntoStatic(location);
    }

    public void doAutoSyncCursorFromStatic() {
        if (!this.isAutoSyncCursorWithStaticListing()) {
            return;
        }
        this.doSyncCursorFromStatic();
    }

    protected void doSetAutoSyncCursorWithStaticListing(boolean sync) {
        this.autoSyncCursorWithStaticListing = sync;
        this.provider.contextChanged();
        this.doAutoSyncCursorIntoStatic(this.currentDynamicLocation);
    }

    protected void doSetAutoSyncSelectionWithStaticListing(boolean sync) {
        this.autoSyncSelectionWithStaticListing = sync;
        this.provider.contextChanged();
        this.doAutoSyncSelectionIntoStatic((Program)this.current.getView(), this.currentDynamicSelection);
    }

    protected ProgramSelection doSyncSelectionIntoStatic(Program program, ProgramSelection sel) {
        if (program == null || sel == null || this.currentStaticProgram == null || this.mappingService == null) {
            return null;
        }
        TraceProgramView view = (TraceProgramView)program;
        Collection<DebuggerStaticMappingService.MappedAddressRange> ranges = this.mappingService.getOpenMappedViews(view.getTrace(), (AddressSetView)sel, view.getSnap()).get(this.currentStaticProgram);
        AddressSet mapped = ranges == null ? new AddressSet() : (AddressSet)ranges.stream().map(r -> r.getDestinationAddressRange()).collect(AddressCollectors.toAddressSet());
        ProgramSelection result = new ProgramSelection((AddressSetView)mapped);
        this.staticSelect(this.currentStaticProgram, result);
        return result;
    }

    protected ProgramSelection doSyncSelectionFromStatic() {
        TraceProgramView view = this.current.getView();
        if (view == null || this.currentStaticProgram == null || this.currentStaticSelection == null || this.mappingService == null) {
            return null;
        }
        AddressSet mapped = (AddressSet)this.mappingService.getOpenMappedViews(this.currentStaticProgram, (AddressSetView)this.currentStaticSelection).entrySet().stream().filter(e -> ((TraceSpan)e.getKey()).getTrace() == this.current.getTrace()).filter(e -> ((TraceSpan)e.getKey()).getSpan().contains((Comparable)Long.valueOf(this.current.getSnap()))).flatMap(e -> ((Collection)e.getValue()).stream()).map(r -> r.getDestinationAddressRange()).collect(AddressCollectors.toAddressSet());
        ProgramSelection result = new ProgramSelection((AddressSetView)mapped);
        this.dynamicSelect((Program)view, result);
        return result;
    }

    protected void doAutoSyncSelectionIntoStatic(Program program, ProgramSelection selection) {
        if (this.isAutoSyncSelectionWithStaticListing()) {
            this.doSyncSelectionIntoStatic(program, selection);
        }
    }

    protected void doAutoSyncSelectionFromStatic() {
        if (this.isAutoSyncSelectionWithStaticListing()) {
            this.doSyncSelectionFromStatic();
        }
    }

    protected void displayMapError(String from, String to) {
        this.tool.setStatusInfo("No selected addresses in " + from + " are mappable to " + to + ". Check your module list and static mappings.", true);
    }

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        this.current = coordinates;
    }

    public void dynamicProgramLocationChanged(ProgramLocation location, EventTrigger trigger) {
        this.currentDynamicLocation = location;
        if (trigger != EventTrigger.GUI_ACTION) {
            return;
        }
        this.doAutoSyncCursorIntoStatic(location);
    }

    public void dynamicSelectionChanged(Program program, ProgramSelection selection, EventTrigger trigger) {
        this.currentDynamicSelection = selection;
        this.provider.contextChanged();
        if (trigger != EventTrigger.GUI_ACTION) {
            return;
        }
        this.doAutoSyncSelectionIntoStatic(program, selection);
    }

    public void staticProgramActivated(Program program) {
        this.currentStaticProgram = program;
    }

    public void staticProgramLocationChanged(ProgramLocation location) {
        this.currentStaticLocation = location;
        this.doAutoSyncCursorFromStatic();
    }

    public void staticProgramSelectionChanged(Program program, ProgramSelection selection) {
        if (program != this.currentStaticProgram) {
            Msg.warn((Object)this, (Object)"Got selection change for not the current static program");
            return;
        }
        this.currentStaticProgram = program;
        this.currentStaticSelection = selection;
        this.provider.contextChanged();
        this.doAutoSyncSelectionFromStatic();
    }

    public void setAutoSyncCursorWithStaticListing(boolean sync) {
        this.actionAutoSyncCursorWithStaticListing.setSelected(sync);
        this.doSetAutoSyncCursorWithStaticListing(sync);
    }

    public boolean isAutoSyncCursorWithStaticListing() {
        return this.autoSyncCursorWithStaticListing;
    }

    public void setAutoSyncSelectionWithStaticListing(boolean sync) {
        this.actionAutoSyncSelectionWithStaticListing.setSelected(sync);
        this.doSetAutoSyncSelectionWithStaticListing(sync);
    }

    public boolean isAutoSyncSelectionWithStaticListing() {
        return this.autoSyncSelectionWithStaticListing;
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        if (this.isAutoSyncAllowed) {
            if (this.actionAutoSyncCursorWithStaticListing != null) {
                this.actionAutoSyncCursorWithStaticListing.setSelected(this.autoSyncCursorWithStaticListing);
            }
            if (this.actionAutoSyncSelectionWithStaticListing != null) {
                this.actionAutoSyncSelectionWithStaticListing.setSelected(this.autoSyncSelectionWithStaticListing);
            }
        } else {
            this.autoSyncCursorWithStaticListing = false;
            this.autoSyncSelectionWithStaticListing = false;
        }
    }

    protected void staticGoTo(ProgramLocation location) {
    }

    protected void staticSelect(Program program, ProgramSelection selection) {
    }

    protected void dynamicGoTo(ProgramLocation location) {
    }

    protected void dynamicSelect(Program program, ProgramSelection selection) {
    }

    protected class ForStaticSyncMappingChangeListener
    implements DebuggerStaticMappingChangeListener {
        protected ForStaticSyncMappingChangeListener() {
        }

        @Override
        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            Swing.runIfSwingOrRunLater(() -> {
                if (DebuggerStaticSyncTrait.this.current.getView() == null) {
                    return;
                }
                if (!affectedTraces.contains(DebuggerStaticSyncTrait.this.current.getTrace())) {
                    return;
                }
                DebuggerStaticSyncTrait.this.doAutoSyncCursorIntoStatic(DebuggerStaticSyncTrait.this.currentDynamicLocation);
                DebuggerStaticSyncTrait.this.doAutoSyncSelectionIntoStatic((Program)DebuggerStaticSyncTrait.this.current.getView(), DebuggerStaticSyncTrait.this.currentDynamicSelection);
            });
        }
    }
}

