/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpecFactory;
import ghidra.app.plugin.core.debug.gui.action.WatchLocationTrackingSpec;
import ghidra.app.services.DebuggerWatchesService;
import ghidra.framework.plugintool.PluginTool;
import java.util.List;
import java.util.stream.Collectors;

public class WatchLocationTrackingSpecFactory
implements LocationTrackingSpecFactory {
    @Override
    public List<LocationTrackingSpec> getSuggested(PluginTool tool) {
        DebuggerWatchesService watchesService = (DebuggerWatchesService)tool.getService(DebuggerWatchesService.class);
        if (watchesService == null) {
            return List.of();
        }
        return watchesService.getWatches().stream().map(WatchLocationTrackingSpec::fromWatch).collect(Collectors.toList());
    }

    @Override
    public LocationTrackingSpec parseSpec(String name) {
        if (!name.startsWith("TRACK_WATCH_")) {
            return null;
        }
        String expression = name.substring("TRACK_WATCH_".length());
        return new WatchLocationTrackingSpec(expression);
    }
}

