/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.listing;

import ghidra.GhidraOptions;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.Objects;

class CursorBackgroundColorModel
implements ListingBackgroundColorModel {
    private Color defaultBackgroundColor;
    private ListingPanel listingPanel;
    private AddressIndexMap addressIndexMap;
    @AutoOptionConsumed(category={}, name={"Cursor.Highlight Cursor Line Color"})
    private Color cursorColor = GhidraOptions.DEFAULT_CURSOR_LINE_COLOR;
    @AutoOptionConsumed(category={}, name={"Cursor.Highlight Cursor Line"})
    private boolean doHighlight = true;
    private final AutoOptions.Wiring autoOptionsWiring;

    public CursorBackgroundColorModel(Plugin plugin, ListingPanel listingPanel) {
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)this);
        this.modelDataChanged(listingPanel);
    }

    public Color getBackgroundColor(BigInteger index) {
        Address address;
        if (this.listingPanel == null || !this.doHighlight) {
            return this.defaultBackgroundColor;
        }
        ProgramLocation loc = this.listingPanel.getProgramLocation();
        if (loc == null) {
            return this.defaultBackgroundColor;
        }
        Address cursorAddress = loc.getAddress();
        if (!Objects.equals(cursorAddress, address = this.addressIndexMap.getAddress(index))) {
            return this.defaultBackgroundColor;
        }
        return this.cursorColor;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        this.defaultBackgroundColor = c;
    }

    public void modelDataChanged(ListingPanel newListingPanel) {
        this.addressIndexMap = newListingPanel.getAddressIndexMap();
        this.listingPanel = newListingPanel;
    }
}

