/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import com.google.common.collect.Range;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ModelQuery {
    private final PathPredicates predicates;

    public static ModelQuery parse(String queryString) {
        return new ModelQuery(PathPredicates.parse((String)queryString));
    }

    public static ModelQuery elementsOf(TraceObjectKeyPath path) {
        return new ModelQuery((PathPredicates)new PathPattern(PathUtils.extend((List)path.getKeyList(), (String)"[]")));
    }

    public static ModelQuery attributesOf(TraceObjectKeyPath path) {
        return new ModelQuery((PathPredicates)new PathPattern(PathUtils.extend((List)path.getKeyList(), (String)"")));
    }

    public ModelQuery(PathPredicates predicates) {
        this.predicates = predicates;
    }

    public String toString() {
        return "<ModelQuery: " + this.predicates.toString() + ">";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModelQuery)) {
            return false;
        }
        ModelQuery that = (ModelQuery)obj;
        return Objects.equals(this.predicates, that.predicates);
    }

    public String toQueryString() {
        return this.predicates.getSingletonPattern().toPatternString();
    }

    public Stream<TraceObject> streamObjects(Trace trace, Range<Long> span) {
        TraceObjectManager objects = trace.getObjectManager();
        TraceObject root = objects.getRootObject();
        return objects.getValuePaths(span, this.predicates).map(p -> p.getDestinationValue((Object)root)).filter(v -> v instanceof TraceObject).map(v -> (TraceObject)v);
    }

    public Stream<TraceObjectValue> streamValues(Trace trace, Range<Long> span) {
        TraceObjectManager objects = trace.getObjectManager();
        return objects.getValuePaths(span, this.predicates).map(p -> {
            TraceObjectValue last = p.getLastEntry();
            return last == null ? objects.getRootObject().getCanonicalParent(0L) : last;
        });
    }

    public Stream<TraceObjectValPath> streamPaths(Trace trace, Range<Long> span) {
        return trace.getObjectManager().getValuePaths(span, this.predicates).map(p -> p);
    }

    public Stream<TargetObjectSchema.AttributeSchema> computeAttributes(Trace trace) {
        TraceObjectManager objects = trace.getObjectManager();
        TargetObjectSchema schema = objects.getRootSchema().getSuccessorSchema(this.predicates.getSingletonPattern().asPath());
        return schema.getAttributeSchemas().values().stream().filter(as -> !"".equals(as.getName()));
    }

    public boolean includes(Range<Long> span, TraceObjectValue value) {
        List path = this.predicates.getSingletonPattern().asPath();
        if (path.isEmpty()) {
            return value.getParent() == null;
        }
        if (!PathPredicates.keyMatches((String)PathUtils.getKey((List)path), (String)value.getEntryKey())) {
            return false;
        }
        if (!DBTraceUtils.intersect(span, (Range)value.getLifespan())) {
            return false;
        }
        TraceObject parent = value.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getAncestors(span, this.predicates.removeRight(1)).anyMatch(v -> v.getSource(parent).isRoot());
    }
}

