/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GTableHeaderRenderer;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.RangeSetTableCellRenderer;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Trace;
import ghidra.util.table.column.GColumnRenderer;

public class TraceValueLifePlotColumn
extends AbstractDynamicTableColumn<ObjectTableModel.ValueRow, RangeSet<Long>, Trace> {
    private final RangeSetTableCellRenderer<Long> cellRenderer = new RangeSetTableCellRenderer();
    private final RangeCursorTableHeaderRenderer<Long> headerRenderer = new RangeCursorTableHeaderRenderer();

    public String getColumnName() {
        return "Plot";
    }

    public RangeSet<Long> getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        return rowObject.getLife();
    }

    public GColumnRenderer<RangeSet<Long>> getColumnRenderer() {
        return this.cellRenderer;
    }

    public GTableHeaderRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setFullRange(Range<Long> fullRange) {
        this.cellRenderer.setFullRange(fullRange);
        this.headerRenderer.setFullRange(fullRange);
    }

    public void setSnap(long snap) {
        this.headerRenderer.setCursorPosition((Number)snap);
    }

    public void addSeekListener(RangeCursorTableHeaderRenderer.SeekListener listener) {
        this.headerRenderer.addSeekListener(listener);
    }
}

