/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.actions.ImportExportAsAction;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ExportAsFactsAction
extends ImportExportAsAction {
    public static String SEP = "\t";
    public static String JOIN = ".";
    public static String SPLIT = "\\.";
    public static String fileExt2 = ".facts";
    protected ImageIcon ICON_FACTS = ResourceManager.loadImage((String)"images/closedFolder.png");
    private Map<String, PrintWriter> files = new HashMap<String, PrintWriter>();

    public ExportAsFactsAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("ExportAsFacts", tool, owner, provider);
        this.fileExt = "";
        this.fileMode = GhidraFileChooserMode.DIRECTORIES_ONLY;
        String[] path = new String[]{"Export as...", "Facts"};
        this.setPopupMenuData(new MenuData(path, (Icon)this.ICON_FACTS));
        this.setKeyBindingData(new KeyBindingData(70, 64));
        this.setHelpLocation(new HelpLocation(owner, "export_as_facts"));
        provider.addLocalAction((DockingActionIf)this);
    }

    @Override
    protected void doAction(ObjectContainer container, File dir) {
        if (container == null) {
            return;
        }
        this.writeFacts(container, dir);
        for (PrintWriter pw : this.files.values()) {
            pw.flush();
            pw.close();
        }
    }

    public String writeFacts(ObjectContainer container, File dir) {
        TargetObject to = container.getTargetObject();
        if (to == null) {
            return "";
        }
        String id = Integer.toHexString(to.getPath().hashCode());
        PrintWriter pw = this.getOrAddWriter(dir, "ObjectPath");
        pw.println(id + SEP + to.getJoinedPath(JOIN));
        pw = this.getOrAddWriter(dir, "ObjectName");
        pw.println(id + SEP + container.getPrefixedName());
        pw = this.getOrAddWriter(dir, "ObjectValue");
        pw.println(id + SEP + to.getDisplay());
        pw = this.getOrAddWriter(dir, "ObjectType");
        pw.println(id + SEP + to.getTypeHint());
        pw = this.getOrAddWriter(dir, "ObjectChildren");
        for (ObjectContainer c : container.getCurrentChildren()) {
            String cid = this.writeFacts(c, dir);
            pw.println(id + SEP + cid);
        }
        return id;
    }

    private PrintWriter getOrAddWriter(File dir, String name) {
        if (this.files.containsKey(name = (String)name + fileExt2)) {
            return this.files.get(name);
        }
        File f = new File(dir, (String)name);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(f);
            this.files.put((String)name, pw);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return pw;
    }
}

