/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.widgets.tree.support.GTreeRenderer;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectNode;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class ObjectTreeCellRenderer
extends GTreeRenderer {
    private final DebuggerObjectsProvider provider;
    private Font defaultFont = SystemUtilities.adjustForFontSizeOverride((Font)new Font("Tahoma", 0, 11));
    private Font unsubscribedFont = SystemUtilities.adjustForFontSizeOverride((Font)new Font("Tahoma", 2, 11));

    public ObjectTreeCellRenderer(DebuggerObjectsProvider provider) {
        this.provider = provider;
    }

    public Component getTreeCellRendererComponent(JTree t, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean focus) {
        Component component = super.getTreeCellRendererComponent(t, value, sel, exp, leaf, row, focus);
        if (value instanceof ObjectNode) {
            ObjectContainer selection;
            Object last;
            TreePath path;
            Color color;
            TargetExecutionStateful stateful;
            Map attrs;
            String kind;
            ObjectNode node = (ObjectNode)((Object)value);
            ObjectContainer container = node.getContainer();
            this.setText(container.getDecoratedName());
            component.setForeground(this.provider.getColor("Object Colors.Default"));
            TargetObject targetObject = container.getTargetObject();
            if (targetObject != null && (kind = (String)(attrs = targetObject.getCachedAttributes()).get("_kind")) != null && !kind.equals("")) {
                if (kind.equals("OBJECT_INTRINSIC")) {
                    container.subscribe();
                }
                this.setColor(component, kind);
            }
            if (!node.isVisible() && !this.provider.isHideIntrinsics()) {
                component.setForeground(this.provider.getColor("Object Colors.Invisible (when toggled on)"));
            }
            if (container.getTargetObject() instanceof TargetExecutionStateful && (stateful = (TargetExecutionStateful)targetObject).getExecutionState().equals((Object)TargetExecutionStateful.TargetExecutionState.TERMINATED)) {
                component.setForeground(this.provider.getColor("Object Colors.Invalidated"));
            }
            if (container.isLink()) {
                component.setForeground(this.provider.getColor("Object Colors.Links"));
            }
            if (container.isModified()) {
                component.setForeground(this.provider.getColor("Object Colors.Modifed"));
            }
            if (container.isSubscribed() && !(color = this.provider.getColor("Object Colors.Subscribed")).equals(Color.BLACK)) {
                component.setForeground(color);
            }
            if ((path = t.getSelectionPath()) != null && (last = path.getLastPathComponent()) instanceof ObjectNode && container.equals(selection = ((ObjectNode)((Object)last)).getContainer())) {
                component.setForeground(Color.WHITE);
            }
            component.setFont(container.isSubscribed() ? this.defaultFont : this.unsubscribedFont);
        }
        return component;
    }

    private void setColor(Component component, String kind) {
        switch (kind) {
            case "OBJECT_PROPERTY_ACCESSOR": {
                component.setForeground(this.provider.getColor("Object Colors.Accessors"));
                break;
            }
            case "OBJECT_INTRINSIC": {
                component.setForeground(this.provider.getColor("Object Colors.Intrinsics"));
                break;
            }
            case "OBJECT_TARGET_OBJECT": {
                component.setForeground(this.provider.getColor("Object Colors.Targets"));
                break;
            }
            case "OBJECT_ERROR": {
                component.setForeground(this.provider.getColor("Object Colors.Errors"));
            }
        }
    }

    protected Component highlight(Component component) {
        return component;
    }
}

