/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.time;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.dialogs.InputDialog;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.DebuggerSnapActionContext;
import ghidra.app.plugin.core.debug.gui.time.DebuggerTimeProvider;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.util.database.UndoableTransaction;
import java.util.Map;

@PluginInfo(shortDescription="Lists recorded snapshots in a trace", description="Provides the component which lists snapshots and allows navigation", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class})
public class DebuggerTimePlugin
extends AbstractDebuggerPlugin {
    protected DebuggerTimeProvider provider;
    protected DockingAction actionRenameSnapshot;

    public DebuggerTimePlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    @Override
    protected void init() {
        this.provider = new DebuggerTimeProvider(this);
        super.init();
    }

    protected void createActions() {
        this.actionRenameSnapshot = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.RenameSnapshotAction.builder(this).enabled(false)).enabledWhen(ctx -> this.contextGetTraceSnap((ActionContext)ctx) != null)).onAction(this::activatedRenameSnapshot)).buildAndInstall((Tool)this.tool);
    }

    protected Map.Entry<Trace, Long> contextGetTraceSnap(ActionContext context) {
        if (context instanceof ProgramLocationActionContext) {
            ProgramLocationActionContext ctx = (ProgramLocationActionContext)context;
            Program program = ctx.getProgram();
            if (program instanceof TraceProgramView) {
                TraceProgramView view = (TraceProgramView)program;
                return Map.entry(view.getTrace(), view.getSnap());
            }
            return null;
        }
        if (context instanceof DebuggerSnapActionContext) {
            DebuggerSnapActionContext ctx = (DebuggerSnapActionContext)context;
            if (ctx.getTrace() != null) {
                return Map.entry(ctx.getTrace(), ctx.getSnap());
            }
            return null;
        }
        return null;
    }

    protected void activatedRenameSnapshot(ActionContext context) {
        Map.Entry<Trace, Long> traceSnap = this.contextGetTraceSnap(context);
        if (traceSnap == null) {
            return;
        }
        Trace trace = traceSnap.getKey();
        long snap = traceSnap.getValue();
        TraceTimeManager manager = trace.getTimeManager();
        TraceSnapshot snapshot = manager.getSnapshot(snap, false);
        InputDialog dialog = new InputDialog("Rename Snapshot", "Description", snapshot == null ? "" : snapshot.getDescription());
        this.tool.showDialog((DialogComponentProvider)dialog);
        if (dialog.isCanceled()) {
            return;
        }
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)trace, (String)"Rename Snapshot");){
            if (snapshot == null) {
                snapshot = manager.getSnapshot(snap, true);
            }
            snapshot.setDescription(dialog.getValue());
        }
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.provider.coordinatesActivated(ev.getActiveCoordinates());
        }
    }

    public void writeConfigState(SaveState saveState) {
        this.provider.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        this.provider.readConfigState(saveState);
    }
}

