/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.dbgeng;

import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.app.plugin.core.debug.workflow.DisassemblyInject;
import ghidra.app.plugin.core.debug.workflow.DisassemblyInjectInfo;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.TraceRecorder;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemBufferByteProvider;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.util.ProgramContextImpl;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

@DisassemblyInjectInfo(langIDs={"x86:LE:64:default"})
public class DbgengX64DisassemblyInject
implements DisassemblyInject {
    @Override
    public void pre(PluginTool tool, TraceDisassembleCommand command, Trace trace, Language language, long snap, TraceThread thread, AddressSetView startSet, AddressSetView restricted) {
        AddressRange first = startSet.getFirstRange();
        if (first == null) {
            return;
        }
        DebuggerModelService modelService = (DebuggerModelService)tool.getService(DebuggerModelService.class);
        TraceRecorder recorder = modelService == null ? null : modelService.getRecorder(trace);
        Collection modules = trace.getModuleManager().getModulesAt(snap, first.getMinAddress());
        Set modes = modules.stream().map(m -> this.modeForModule(recorder, trace, snap, (TraceModule)m)).filter(m -> m != Mode.UNK).collect(Collectors.toSet());
        if (modes.size() != 1) {
            return;
        }
        Mode mode = (Mode)((Object)modes.iterator().next());
        Register addrsizeReg = language.getRegister("addrsize");
        Register opsizeReg = language.getRegister("opsize");
        ProgramContextImpl context = new ProgramContextImpl(language);
        language.applyContextSettings((DefaultProgramContext)context);
        RegisterValue ctxVal = context.getDisassemblyContext(first.getMinAddress());
        if (mode == Mode.X64) {
            command.setInitialContext(ctxVal.assign(addrsizeReg, BigInteger.TWO).assign(opsizeReg, BigInteger.TWO));
        } else if (mode == Mode.X86) {
            command.setInitialContext(ctxVal.assign(addrsizeReg, BigInteger.ONE).assign(opsizeReg, BigInteger.ONE));
        }
    }

    protected Mode modeForModule(TraceRecorder recorder, Trace trace, long snap, TraceModule module) {
        if (recorder != null && recorder.getSnap() == snap) {
            AddressSet set = new AddressSet();
            set.add(module.getBase(), module.getBase());
            try {
                recorder.readMemoryBlocks((AddressSetView)set, TaskMonitor.DUMMY).get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Msg.error((Object)"Could not read module header from target", (Object)e);
            }
        }
        MemBuffer bufferAt = trace.getMemoryManager().getBufferAt(snap, module.getBase());
        MemBufferByteProvider bp = new MemBufferByteProvider(bufferAt);
        try {
            PortableExecutable pe = new PortableExecutable((ByteProvider)bp, PortableExecutable.SectionLayout.MEMORY, false, false);
            NTHeader ntHeader = pe.getNTHeader();
            if (ntHeader == null) {
                return Mode.UNK;
            }
            OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
            if (optionalHeader == null) {
                return Mode.UNK;
            }
            return optionalHeader.is64bit() ? Mode.X64 : Mode.X86;
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)("Could not parse PE from trace: " + e));
            return Mode.UNK;
        }
    }

    static enum Mode {
        X64,
        X86,
        UNK;

    }
}

