/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerDataAccess;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.BytesTracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractRWTargetPcodeExecutorStatePiece
extends BytesTracePcodeExecutorStatePiece {
    protected final PcodeDebuggerDataAccess data;

    public AbstractRWTargetPcodeExecutorStatePiece(PcodeDebuggerDataAccess data) {
        super((PcodeTraceDataAccess)data);
        this.data = data;
    }

    protected abstract class TargetBackedSpaceMap
    extends AbstractLongOffsetPcodeExecutorStatePiece.CacheingSpaceMap<PcodeDebuggerDataAccess, BytesTracePcodeExecutorStatePiece.CachedSpace> {
        protected TargetBackedSpaceMap() {
        }

        protected PcodeDebuggerDataAccess getBacking(AddressSpace space) {
            return AbstractRWTargetPcodeExecutorStatePiece.this.data;
        }
    }

    abstract class AbstractRWTargetCachedSpace
    extends BytesTracePcodeExecutorStatePiece.CachedSpace {
        public AbstractRWTargetCachedSpace(Language language, AddressSpace space, PcodeDebuggerDataAccess backing) {
            super(language, space, (PcodeTraceDataAccess)backing);
        }

        protected abstract void fillUninitialized(AddressSet var1);

        public byte[] read(long offset, int size, PcodeExecutorStatePiece.Reason reason) {
            if (this.backing != null) {
                AddressSet uninitialized = this.addrSet(this.bytes.getUninitialized(offset, offset + (long)size - 1L));
                if (uninitialized.isEmpty()) {
                    return super.read(offset, size, reason);
                }
                this.fillUninitialized(uninitialized);
                AddressSetView unknown = ((PcodeTraceDataAccess)this.backing).intersectUnknown((AddressSetView)this.addrSet(this.bytes.getUninitialized(offset, offset + (long)size - 1L)));
                if (!unknown.isEmpty() && reason == PcodeExecutorStatePiece.Reason.EXECUTE) {
                    this.warnUnknown(unknown);
                }
            }
            return super.read(offset, size, reason);
        }

        protected <T> T waitTimeout(CompletableFuture<T> future) {
            try {
                return future.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new AccessPcodeExecutionException("Timed out reading or writing target", (Exception)e);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new AccessPcodeExecutionException("Error reading or writing target", e);
            }
        }
    }
}

