/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import ghidra.app.plugin.core.debug.service.emulation.AbstractRWTargetPcodeExecutorStatePiece;
import ghidra.app.plugin.core.debug.service.emulation.Mode;
import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerDataAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerMemoryAccess;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.BytesTracePcodeExecutorStatePiece;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;

public class RWTargetMemoryPcodeExecutorStatePiece
extends AbstractRWTargetPcodeExecutorStatePiece {
    private final Mode mode;

    public RWTargetMemoryPcodeExecutorStatePiece(PcodeDebuggerMemoryAccess data, Mode mode) {
        super(data);
        this.mode = mode;
    }

    protected AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<BytesTracePcodeExecutorStatePiece.CachedSpace> newSpaceMap() {
        return new AbstractRWTargetPcodeExecutorStatePiece.TargetBackedSpaceMap(){

            protected BytesTracePcodeExecutorStatePiece.CachedSpace newSpace(AddressSpace space, PcodeDebuggerDataAccess data) {
                return new RWTargetMemoryCachedSpace(RWTargetMemoryPcodeExecutorStatePiece.this.language, space, (PcodeDebuggerMemoryAccess)data);
            }
        };
    }

    protected class RWTargetMemoryCachedSpace
    extends AbstractRWTargetPcodeExecutorStatePiece.AbstractRWTargetCachedSpace {
        protected final PcodeDebuggerMemoryAccess backing;

        public RWTargetMemoryCachedSpace(Language language, AddressSpace space, PcodeDebuggerMemoryAccess backing) {
            super(RWTargetMemoryPcodeExecutorStatePiece.this, language, space, backing);
            this.backing = backing;
        }

        @Override
        protected void fillUninitialized(AddressSet uninitialized) {
            if (this.space.isUniqueSpace()) {
                return;
            }
            AddressSetView unknown = this.backing.intersectUnknown((AddressSetView)uninitialized);
            if (unknown.isEmpty()) {
                return;
            }
            if (this.waitTimeout(this.backing.readFromTargetMemory(unknown)).booleanValue() && (unknown = this.backing.intersectUnknown((AddressSetView)uninitialized)).isEmpty()) {
                return;
            }
            if (this.backing.readFromStaticImages(this.bytes, unknown) && (unknown = this.backing.intersectUnknown((AddressSetView)uninitialized)).isEmpty()) {
                return;
            }
        }

        public void write(long offset, byte[] val, int srcOffset, int length) {
            if (RWTargetMemoryPcodeExecutorStatePiece.this.mode.isWriteTarget() && !this.space.isUniqueSpace() && this.waitTimeout(this.backing.writeTargetMemory(this.space.getAddress(offset), val)).booleanValue()) {
                return;
            }
            super.write(offset, val, srcOffset, length);
        }
    }
}

