/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation.data;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.service.emulation.data.InternalPcodeDebuggerDataAccess;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.pcode.exec.trace.data.DefaultPcodeTracePropertyAccess;
import ghidra.pcode.exec.trace.data.InternalPcodeTraceDataAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.TraceLocation;

public class DefaultPcodeDebuggerPropertyAccess<T>
extends DefaultPcodeTracePropertyAccess<T> {
    protected final InternalPcodeDebuggerDataAccess data;

    protected DefaultPcodeDebuggerPropertyAccess(InternalPcodeDebuggerDataAccess data, String name, Class<T> type) {
        super((InternalPcodeTraceDataAccess)data, name, type);
        this.data = data;
    }

    protected T whenNull(Address hostAddress) {
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)this.data.getTool().getService(DebuggerStaticMappingService.class);
        if (mappingService == null) {
            return (T)super.whenNull(hostAddress);
        }
        ProgramLocation progLoc = mappingService.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(this.data.getPlatform().getTrace(), null, Range.singleton((Comparable)Long.valueOf(this.data.getSnap())), hostAddress));
        if (progLoc == null) {
            return (T)super.whenNull(hostAddress);
        }
        PropertyMap map = progLoc.getProgram().getUsrPropertyManager().getPropertyMap(this.name);
        if (map == null) {
            return (T)super.whenNull(hostAddress);
        }
        Object object = map.get(progLoc.getByteAddress());
        if (!this.type.isInstance(object)) {
            return (T)super.whenNull(hostAddress);
        }
        return this.type.cast(object);
    }
}

