/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.app.services.MapEntry;
import ghidra.framework.data.OpenedDomainFile;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.store.FileSystem;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class DebuggerStaticMappingUtils
extends Enum<DebuggerStaticMappingUtils> {
    private static final /* synthetic */ DebuggerStaticMappingUtils[] $VALUES;

    public static DebuggerStaticMappingUtils[] values() {
        return (DebuggerStaticMappingUtils[])$VALUES.clone();
    }

    public static DebuggerStaticMappingUtils valueOf(String name) {
        return Enum.valueOf(DebuggerStaticMappingUtils.class, name);
    }

    protected static <T> T noProject(Object originator) {
        Msg.warn((Object)originator, (Object)"The given program does not exist in any project");
        return null;
    }

    public static DomainFile resolve(DomainFolder folder, String path) {
        StringBuilder fullPath = new StringBuilder(folder.getPathname());
        if (!fullPath.toString().endsWith(FileSystem.SEPARATOR)) {
            fullPath.append('/');
        }
        fullPath.append(path);
        return folder.getProjectData().getFile(fullPath.toString());
    }

    public static Set<DomainFile> findPrograms(String modulePath, DomainFolder folder) {
        while (folder != null) {
            DomainFile found = DebuggerStaticMappingUtils.resolve(folder, modulePath);
            if (found != null) {
                return Set.of(found);
            }
            folder = folder.getParent();
        }
        return Set.of();
    }

    public static Set<DomainFile> findProgramsByPathOrName(String modulePath, DomainFolder folder) {
        Set<DomainFile> found = DebuggerStaticMappingUtils.findPrograms(modulePath, folder);
        if (!found.isEmpty()) {
            return found;
        }
        int idx = modulePath.lastIndexOf(FileSystem.SEPARATOR);
        if (idx == -1) {
            return Set.of();
        }
        found = DebuggerStaticMappingUtils.findPrograms(modulePath.substring(idx + 1), folder);
        if (!found.isEmpty()) {
            return found;
        }
        return Set.of();
    }

    public static Set<DomainFile> findProgramsByPathOrName(String modulePath, Project project) {
        return DebuggerStaticMappingUtils.findProgramsByPathOrName(modulePath, project.getProjectData().getRootFolder());
    }

    protected static String normalizePath(String path) {
        path = path.replace('\\', '/');
        while (path.startsWith(FileSystem.SEPARATOR)) {
            path = path.substring(1);
        }
        return path;
    }

    public static Set<DomainFile> findProbableModulePrograms(TraceModule module, Project project) {
        DomainFile df = module.getTrace().getDomainFile();
        String modulePath = DebuggerStaticMappingUtils.normalizePath(module.getName());
        if (df == null) {
            return DebuggerStaticMappingUtils.findProgramsByPathOrName(modulePath, project);
        }
        DomainFolder parent = df.getParent();
        if (parent == null) {
            return DebuggerStaticMappingUtils.findProgramsByPathOrName(modulePath, project);
        }
        return DebuggerStaticMappingUtils.findProgramsByPathOrName(modulePath, parent);
    }

    protected static void collectLibraries(ProjectData project, Program cur, Set<Program> col, TaskMonitor monitor) throws CancelledException {
        if (!col.add(cur)) {
            return;
        }
        ExternalManager externs = cur.getExternalManager();
        for (String extName : externs.getExternalLibraryNames()) {
            monitor.checkCanceled();
            Library lib = externs.getExternalLibrary(extName);
            String libPath = lib.getAssociatedProgramPath();
            if (libPath == null) continue;
            DomainFile libFile = project.getFile(libPath);
            if (libFile == null) {
                Msg.info(DebuggerStaticMappingUtils.class, (Object)("Referenced external program not found: " + libPath));
                continue;
            }
            try (OpenedDomainFile program = OpenedDomainFile.open(Program.class, (DomainFile)libFile, (TaskMonitor)monitor);){
                DebuggerStaticMappingUtils.collectLibraries(project, (Program)program.content, col, monitor);
            }
            catch (ClassCastException e) {
                Msg.info(DebuggerStaticMappingUtils.class, (Object)("Referenced external program is not a program: " + libPath + " is " + libFile.getDomainObjectClass()));
            }
            catch (CancelledException | VersionException | IOException e) {
                Msg.info(DebuggerStaticMappingUtils.class, (Object)("Referenced external program could not be opened: " + (Exception)e));
            }
        }
    }

    public static Set<Program> collectLibraries(Program seed, TaskMonitor monitor) throws CancelledException {
        LinkedHashSet<Program> result = new LinkedHashSet<Program>();
        DebuggerStaticMappingUtils.collectLibraries(seed.getDomainFile().getParent().getProjectData(), seed, result, monitor);
        return result;
    }

    public static void addMapping(TraceLocation from, ProgramLocation to, long length, boolean truncateExisting) throws TraceConflictedMappingException {
        Program tp = to.getProgram();
        if (tp instanceof TraceProgramView) {
            throw new IllegalArgumentException("Mapping destination cannot be a " + TraceProgramView.class.getSimpleName());
        }
        TraceStaticMappingManager manager = from.getTrace().getStaticMappingManager();
        URL toURL = ProgramURLUtils.getUrlFromProgram(tp);
        if (toURL == null) {
            DebuggerStaticMappingUtils.noProject(DebuggerStaticMappingUtils.class);
        }
        Address fromAddress = from.getAddress();
        Address toAddress = to.getByteAddress();
        long maxFromLengthMinus1 = fromAddress.getAddressSpace().getMaxAddress().subtract(fromAddress);
        long maxToLengthMinus1 = toAddress.getAddressSpace().getMaxAddress().subtract(toAddress);
        if (Long.compareUnsigned(length - 1L, maxFromLengthMinus1) > 0) {
            throw new IllegalArgumentException("Length would cause address overflow in trace");
        }
        if (Long.compareUnsigned(length - 1L, maxToLengthMinus1) > 0) {
            throw new IllegalArgumentException("Length would cause address overflow in program");
        }
        Address end = fromAddress.addWrap(length - 1L);
        AddressRangeImpl range = new AddressRangeImpl(fromAddress, end);
        Range fromLifespan = from.getLifespan();
        if (truncateExisting) {
            long truncEnd = DBTraceUtils.lowerEndpoint((Range)fromLifespan) - 1L;
            for (TraceStaticMapping existing : List.copyOf(manager.findAllOverlapping((AddressRange)range, fromLifespan))) {
                existing.delete();
                if (!fromLifespan.hasLowerBound() || Long.compare(existing.getStartSnap(), truncEnd) > 0) continue;
                manager.add(existing.getTraceAddressRange(), Range.closed((Comparable)Long.valueOf(existing.getStartSnap()), (Comparable)Long.valueOf(truncEnd)), existing.getStaticProgramURL(), existing.getStaticAddress());
            }
        }
        manager.add((AddressRange)range, fromLifespan, toURL, toAddress.toString(true));
    }

    public static void addMapping(MapEntry<?, ?> entry, boolean truncateExisting) throws TraceConflictedMappingException {
        TraceLocation fromLoc = entry.getFromTraceLocation();
        ProgramLocation toLoc = entry.getToProgramLocation();
        long length = entry.getMappingLength();
        DebuggerStaticMappingUtils.addMapping(fromLoc, toLoc, length, truncateExisting);
    }

    public static void addIdentityMapping(Trace from, Program toProgram, Range<Long> lifespan, boolean truncateExisting) {
        HashMap<String, Address> mins = new HashMap<String, Address>();
        HashMap<String, Address> maxs = new HashMap<String, Address>();
        for (AddressRange range : toProgram.getMemory().getAddressRanges()) {
            mins.compute(range.getAddressSpace().getName(), (n, min) -> {
                Address can = range.getMinAddress();
                if (min == null || can.compareTo(min) < 0) {
                    return can;
                }
                return min;
            });
            maxs.compute(range.getAddressSpace().getName(), (n, max) -> {
                Address can = range.getMaxAddress();
                if (max == null || can.compareTo(max) > 0) {
                    return can;
                }
                return max;
            });
        }
        for (String name : mins.keySet()) {
            AddressRange range = DebuggerStaticMappingUtils.clippedRange(from, name, ((Address)mins.get(name)).getOffset(), ((Address)maxs.get(name)).getOffset());
            if (range == null) continue;
            try {
                DebuggerStaticMappingUtils.addMapping((TraceLocation)new DefaultTraceLocation(from, null, lifespan, range.getMinAddress()), new ProgramLocation(toProgram, (Address)mins.get(name)), range.getLength(), truncateExisting);
            }
            catch (TraceConflictedMappingException e) {
                Msg.error(DebuggerStaticMappingUtils.class, (Object)("Could not add identity mapping " + range + ": " + e.getMessage()));
            }
        }
    }

    protected static AddressRange clippedRange(Trace trace, String spaceName, long min, long max) {
        AddressSpace space = trace.getBaseAddressFactory().getAddressSpace(spaceName);
        if (space == null) {
            return null;
        }
        Address spaceMax = space.getMaxAddress();
        if (Long.compareUnsigned(min, spaceMax.getOffset()) > 0) {
            return null;
        }
        if (Long.compareUnsigned(max, spaceMax.getOffset()) > 0) {
            return new AddressRangeImpl(space.getAddress(min), spaceMax);
        }
        return new AddressRangeImpl(space.getAddress(min), space.getAddress(max));
    }

    private static /* synthetic */ DebuggerStaticMappingUtils[] $values() {
        return new DebuggerStaticMappingUtils[0];
    }

    static {
        $VALUES = DebuggerStaticMappingUtils.$values();
    }
}

