/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.service.emulation.Mode;
import ghidra.app.plugin.core.debug.service.emulation.RWTargetMemoryPcodeExecutorState;
import ghidra.app.plugin.core.debug.service.emulation.RWTargetRegistersPcodeExecutorState;
import ghidra.app.plugin.core.debug.service.emulation.data.DefaultPcodeDebuggerAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerMemoryAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerRegistersAccess;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.emu.ThreadPcodeExecutorState;
import ghidra.pcode.exec.AddressOfPcodeArithmetic;
import ghidra.pcode.exec.AddressOfPcodeExecutorStatePiece;
import ghidra.pcode.exec.AddressesReadPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.AddressesReadTracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeArithmetic;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryState;

public final class DebuggerPcodeUtils
extends Enum<DebuggerPcodeUtils> {
    private static final /* synthetic */ DebuggerPcodeUtils[] $VALUES;

    public static DebuggerPcodeUtils[] values() {
        return (DebuggerPcodeUtils[])$VALUES.clone();
    }

    public static DebuggerPcodeUtils valueOf(String name) {
        return Enum.valueOf(DebuggerPcodeUtils.class, name);
    }

    public static PcodeExecutorState<byte[]> executorStateForCoordinates(PluginTool tool, DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        if (trace == null) {
            throw new IllegalArgumentException("Coordinates have no trace");
        }
        TracePlatform platform = coordinates.getPlatform();
        Language language = platform.getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Given trace or platform does not use a Sleigh language");
        }
        DefaultPcodeDebuggerAccess access = new DefaultPcodeDebuggerAccess(tool, coordinates.getRecorder(), platform, coordinates.getViewSnap());
        RWTargetMemoryPcodeExecutorState shared = new RWTargetMemoryPcodeExecutorState((PcodeDebuggerMemoryAccess)access.getDataForSharedState(), Mode.RW);
        if (coordinates.getThread() == null) {
            return shared;
        }
        RWTargetRegistersPcodeExecutorState local = new RWTargetRegistersPcodeExecutorState((PcodeDebuggerRegistersAccess)access.getDataForLocalState(coordinates.getThread(), coordinates.getFrame()), Mode.RW);
        return new ThreadPcodeExecutorState<byte[]>((PcodeExecutorState)shared, (PcodeExecutorState)local, (PcodeExecutorState)shared, (PcodeExecutorState)local){
            final /* synthetic */ PcodeExecutorState val$shared;
            final /* synthetic */ PcodeExecutorState val$local;
            {
                this.val$shared = pcodeExecutorState;
                this.val$local = pcodeExecutorState2;
                super(arg0, arg1);
            }

            public void clear() {
                this.val$shared.clear();
                this.val$local.clear();
            }
        };
    }

    public static PcodeExecutor<byte[]> executorForCoordinates(PluginTool tool, DebuggerCoordinates coordinates) {
        PcodeExecutorState<byte[]> state = DebuggerPcodeUtils.executorStateForCoordinates(tool, coordinates);
        SleighLanguage slang = (SleighLanguage)state.getLanguage();
        return new PcodeExecutor(slang, (PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)slang), state, PcodeExecutorStatePiece.Reason.INSPECT);
    }

    public static WatchValuePcodeExecutorState buildWatchState(PluginTool tool, DebuggerCoordinates coordinates) {
        PcodeTraceDataAccess data = new DefaultPcodeTraceAccess(coordinates.getPlatform(), coordinates.getViewSnap(), coordinates.getSnap()).getDataForThreadState(coordinates.getThread(), coordinates.getFrame());
        PcodeExecutorState<byte[]> bytesState = DebuggerPcodeUtils.executorStateForCoordinates(tool, coordinates);
        return new WatchValuePcodeExecutorState(new WatchValuePcodeExecutorStatePiece((PcodeExecutorStatePiece<byte[], byte[]>)bytesState, (PcodeExecutorStatePiece<byte[], TraceMemoryState>)new TraceMemoryStatePcodeExecutorStatePiece(data), (PcodeExecutorStatePiece<byte[], Address>)new AddressOfPcodeExecutorStatePiece(data.getLanguage()), (PcodeExecutorStatePiece<byte[], AddressSetView>)new AddressesReadTracePcodeExecutorStatePiece(data)));
    }

    public static PcodeExecutor<WatchValue> buildWatchExecutor(PluginTool tool, DebuggerCoordinates coordinates) {
        TracePlatform platform = coordinates.getPlatform();
        Language language = platform.getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Watch expressions require a Sleigh language");
        }
        SleighLanguage slang = (SleighLanguage)language;
        WatchValuePcodeExecutorState state = DebuggerPcodeUtils.buildWatchState(tool, coordinates);
        return new PcodeExecutor(slang, state.getArithmetic(), (PcodeExecutorState)state, PcodeExecutorStatePiece.Reason.INSPECT);
    }

    private static /* synthetic */ DebuggerPcodeUtils[] $values() {
        return new DebuggerPcodeUtils[0];
    }

    static {
        $VALUES = DebuggerPcodeUtils.$values();
    }

    public static class WatchValuePcodeExecutorState
    implements PcodeExecutorState<WatchValue> {
        private WatchValuePcodeExecutorStatePiece piece;

        public WatchValuePcodeExecutorState(WatchValuePcodeExecutorStatePiece piece) {
            this.piece = piece;
        }

        public Language getLanguage() {
            return this.piece.getLanguage();
        }

        public PcodeArithmetic<WatchValue> getArithmetic() {
            return this.piece.arithmetic;
        }

        public void setVar(AddressSpace space, WatchValue offset, int size, boolean quantize, WatchValue val) {
            this.piece.setVar(space, offset.bytes, size, quantize, val);
        }

        public WatchValue getVar(AddressSpace space, WatchValue offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
            return this.piece.getVar(space, offset.bytes, size, quantize, reason);
        }

        public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
            return this.piece.getConcreteBuffer(address, purpose);
        }

        public void clear() {
            this.piece.clear();
        }
    }

    public static class WatchValuePcodeExecutorStatePiece
    implements PcodeExecutorStatePiece<byte[], WatchValue> {
        private final PcodeExecutorStatePiece<byte[], byte[]> bytesPiece;
        private final PcodeExecutorStatePiece<byte[], TraceMemoryState> statePiece;
        private final PcodeExecutorStatePiece<byte[], Address> addressPiece;
        private final PcodeExecutorStatePiece<byte[], AddressSetView> readsPiece;
        private final PcodeArithmetic<WatchValue> arithmetic;

        public WatchValuePcodeExecutorStatePiece(PcodeExecutorStatePiece<byte[], byte[]> bytesPiece, PcodeExecutorStatePiece<byte[], TraceMemoryState> statePiece, PcodeExecutorStatePiece<byte[], Address> addressPiece, PcodeExecutorStatePiece<byte[], AddressSetView> readsPiece) {
            this.bytesPiece = bytesPiece;
            this.statePiece = statePiece;
            this.addressPiece = addressPiece;
            this.readsPiece = readsPiece;
            this.arithmetic = WatchValuePcodeArithmetic.forLanguage(bytesPiece.getLanguage());
        }

        public Language getLanguage() {
            return this.bytesPiece.getLanguage();
        }

        public PcodeArithmetic<byte[]> getAddressArithmetic() {
            return this.bytesPiece.getAddressArithmetic();
        }

        public PcodeArithmetic<WatchValue> getArithmetic() {
            return this.arithmetic;
        }

        public void setVar(AddressSpace space, byte[] offset, int size, boolean quantize, WatchValue val) {
            this.bytesPiece.setVar(space, (Object)offset, size, quantize, (Object)val.bytes);
            this.statePiece.setVar(space, (Object)offset, size, quantize, (Object)val.state);
            this.addressPiece.setVar(space, (Object)offset, size, quantize, (Object)val.address);
            this.readsPiece.setVar(space, (Object)offset, size, quantize, (Object)val.reads);
        }

        public WatchValue getVar(AddressSpace space, byte[] offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
            return new WatchValue((byte[])this.bytesPiece.getVar(space, (Object)offset, size, quantize, reason), (TraceMemoryState)this.statePiece.getVar(space, (Object)offset, size, quantize, reason), (Address)this.addressPiece.getVar(space, (Object)offset, size, quantize, reason), (AddressSetView)this.readsPiece.getVar(space, (Object)offset, size, quantize, reason));
        }

        public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
            return this.bytesPiece.getConcreteBuffer(address, purpose);
        }

        public void clear() {
            this.bytesPiece.clear();
            this.statePiece.clear();
            this.addressPiece.clear();
            this.readsPiece.clear();
        }
    }

    public static enum WatchValuePcodeArithmetic implements PcodeArithmetic<WatchValue>
    {
        BIG_ENDIAN(BytesPcodeArithmetic.BIG_ENDIAN),
        LITTLE_ENDIAN(BytesPcodeArithmetic.LITTLE_ENDIAN);

        private static final TraceMemoryStatePcodeArithmetic STATE;
        private static final AddressOfPcodeArithmetic ADDRESS;
        private static final AddressesReadPcodeArithmetic READS;
        private final BytesPcodeArithmetic bytes;

        public static WatchValuePcodeArithmetic forEndian(boolean isBigEndian) {
            return isBigEndian ? BIG_ENDIAN : LITTLE_ENDIAN;
        }

        public static WatchValuePcodeArithmetic forLanguage(Language language) {
            return WatchValuePcodeArithmetic.forEndian(language.isBigEndian());
        }

        private WatchValuePcodeArithmetic(BytesPcodeArithmetic bytes) {
            this.bytes = bytes;
        }

        public Endian getEndian() {
            return this.bytes.getEndian();
        }

        public WatchValue unaryOp(int opcode, int sizeout, int sizein1, WatchValue in1) {
            return new WatchValue(this.bytes.unaryOp(opcode, sizeout, sizein1, in1.bytes), STATE.unaryOp(opcode, sizeout, sizein1, in1.state), ADDRESS.unaryOp(opcode, sizeout, sizein1, in1.address), READS.unaryOp(opcode, sizeout, sizein1, in1.reads));
        }

        public WatchValue binaryOp(int opcode, int sizeout, int sizein1, WatchValue in1, int sizein2, WatchValue in2) {
            return new WatchValue(this.bytes.binaryOp(opcode, sizeout, sizein1, in1.bytes, sizein2, in2.bytes), STATE.binaryOp(opcode, sizeout, sizein1, in1.state, sizein2, in2.state), ADDRESS.binaryOp(opcode, sizeout, sizein1, in1.address, sizein2, in2.address), READS.binaryOp(opcode, sizeout, sizein1, in1.reads, sizein2, in2.reads));
        }

        public WatchValue modBeforeStore(int sizeout, int sizeinAddress, WatchValue inAddress, int sizeinValue, WatchValue inValue) {
            return new WatchValue(this.bytes.modBeforeStore(sizeout, sizeinAddress, inAddress.bytes, sizeinValue, inValue.bytes), STATE.modBeforeStore(sizeout, sizeinAddress, inAddress.state, sizeinValue, inValue.state), ADDRESS.modBeforeStore(sizeout, sizeinAddress, inAddress.address, sizeinValue, inValue.address), READS.modBeforeStore(sizeout, sizeinAddress, inAddress.reads, sizeinValue, inValue.reads));
        }

        public WatchValue modAfterLoad(int sizeout, int sizeinAddress, WatchValue inAddress, int sizeinValue, WatchValue inValue) {
            return new WatchValue(this.bytes.modAfterLoad(sizeout, sizeinAddress, inAddress.bytes, sizeinValue, inValue.bytes), STATE.modAfterLoad(sizeout, sizeinAddress, inAddress.state, sizeinValue, inValue.state), ADDRESS.modAfterLoad(sizeout, sizeinAddress, inAddress.address, sizeinValue, inValue.address), READS.modAfterLoad(sizeout, sizeinAddress, inAddress.reads, sizeinValue, inValue.reads));
        }

        public WatchValue fromConst(byte[] value) {
            return new WatchValue(this.bytes.fromConst(value), STATE.fromConst(value), ADDRESS.fromConst(value), READS.fromConst(value));
        }

        public byte[] toConcrete(WatchValue value, PcodeArithmetic.Purpose purpose) {
            return this.bytes.toConcrete(value.bytes, purpose);
        }

        public long sizeOf(WatchValue value) {
            return this.bytes.sizeOf(value.bytes);
        }

        static {
            STATE = TraceMemoryStatePcodeArithmetic.INSTANCE;
            ADDRESS = AddressOfPcodeArithmetic.INSTANCE;
            READS = AddressesReadPcodeArithmetic.INSTANCE;
        }
    }

    public record WatchValue(byte[] bytes, TraceMemoryState state, Address address, AddressSetView reads) {
    }
}

