/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeArithmetic;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.memory.TraceMemoryState;
import java.util.Map;

public class TraceMemoryStatePcodeExecutorStatePiece
extends AbstractLongOffsetPcodeExecutorStatePiece<byte[], TraceMemoryState, AddressSpace> {
    protected final RangeMap<UnsignedLong, TraceMemoryState> unique = TreeRangeMap.create();
    protected final PcodeTraceDataAccess data;

    public TraceMemoryStatePcodeExecutorStatePiece(PcodeTraceDataAccess data) {
        super(data.getLanguage(), (PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)data.getLanguage()), (PcodeArithmetic)TraceMemoryStatePcodeArithmetic.INSTANCE);
        this.data = data;
    }

    protected Range<UnsignedLong> range(long offset, int size) {
        return Range.closedOpen((Comparable)UnsignedLong.fromLongBits((long)offset), (Comparable)UnsignedLong.fromLongBits((long)(offset + (long)size)));
    }

    protected AddressRange range(AddressSpace space, long offset, int size) {
        try {
            return new AddressRangeImpl(space.getAddress(offset), (long)size);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void setUnique(long offset, int size, TraceMemoryState val) {
        this.unique.put(this.range(offset, size), (Object)val);
    }

    protected TraceMemoryState getUnique(long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        TreeRangeSet remains = TreeRangeSet.create();
        Range<UnsignedLong> range = this.range(offset, size);
        remains.add(range);
        for (Map.Entry ent : this.unique.subRangeMap(range).asMapOfRanges().entrySet()) {
            if (ent.getValue() != TraceMemoryState.KNOWN) {
                return TraceMemoryState.UNKNOWN;
            }
            remains.remove((Range)ent.getKey());
        }
        return remains.isEmpty() ? TraceMemoryState.KNOWN : TraceMemoryState.UNKNOWN;
    }

    protected AddressSpace getForSpace(AddressSpace space, boolean toWrite) {
        return space;
    }

    protected void setInSpace(AddressSpace space, long offset, int size, TraceMemoryState val) {
        this.data.setState(this.range(space, offset, size), val);
    }

    protected TraceMemoryState getFromSpace(AddressSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return this.data.getViewportState(this.range(space, offset, size));
    }

    protected TraceMemoryState getFromNullSpace(int size, PcodeExecutorStatePiece.Reason reason) {
        return TraceMemoryState.UNKNOWN;
    }

    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        throw new ConcretionError("Cannot make TraceMemoryState into a concrete buffer", purpose);
    }

    public void clear() {
        this.unique.clear();
    }
}

