/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import com.google.common.collect.Range;
import generic.NestedIterator;
import ghidra.lifecycle.Unfinished;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.symbol.DBTraceFunctionSymbol;
import ghidra.trace.database.symbol.DBTraceFunctionSymbolView;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceReference;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.symbol.TraceFunctionSymbol;
import ghidra.trace.util.EmptyFunctionIterator;
import ghidra.trace.util.WrappingFunctionIterator;
import ghidra.util.LockHold;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DBTraceProgramViewFunctionManager
implements FunctionManager {
    protected final DBTraceProgramView program;
    protected final DBTraceFunctionSymbolView functions;
    protected final DBTraceNamespaceSymbol global;

    public DBTraceProgramViewFunctionManager(DBTraceProgramView program) {
        this.program = program;
        this.functions = program.trace.getSymbolManager().functions();
        this.global = program.trace.getSymbolManager().getGlobalNamespace();
    }

    public Program getProgram() {
        return this.program;
    }

    public FunctionTagManager getFunctionTagManager() {
        return (FunctionTagManager)Unfinished.TODO();
    }

    public List<String> getCallingConventionNames() {
        return this.functions.getCallingConventionNames();
    }

    public PrototypeModel getDefaultCallingConvention() {
        return this.functions.getDefaultCallingConvention();
    }

    public PrototypeModel getCallingConvention(String name) {
        return this.functions.getCallingConvention(name);
    }

    public PrototypeModel[] getCallingConventions() {
        return this.functions.getCallingConventions();
    }

    public TraceFunctionSymbol createFunction(String name, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        return this.functions.create(this.program.snap, entryPoint, body, name, null, this.global, source);
    }

    protected static DBTraceNamespaceSymbol validateParent(Namespace nameSpace) {
        if (!(nameSpace instanceof DBTraceNamespaceSymbol)) {
            throw new IllegalArgumentException("Given namespace is not part of this trace");
        }
        return (DBTraceNamespaceSymbol)nameSpace;
    }

    protected static DBTraceFunctionSymbol validateThunked(Function thunked) {
        if (!(thunked instanceof DBTraceFunctionSymbol)) {
            throw new IllegalArgumentException("Given thunked function is not part of this trace");
        }
        return (DBTraceFunctionSymbol)thunked;
    }

    public TraceFunctionSymbol createFunction(String name, Namespace nameSpace, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        return this.functions.create(this.program.snap, entryPoint, body, name, null, DBTraceProgramViewFunctionManager.validateParent(nameSpace), source);
    }

    public TraceFunctionSymbol createThunkFunction(String name, Namespace nameSpace, Address entryPoint, AddressSetView body, Function thunkedFunction, SourceType source) throws OverlappingFunctionException {
        try {
            return this.functions.create(this.program.snap, entryPoint, body, name, DBTraceProgramViewFunctionManager.validateThunked(thunkedFunction), DBTraceProgramViewFunctionManager.validateParent(nameSpace), source);
        }
        catch (InvalidInputException e) {
            throw new RuntimeException("Unexpected for default named function", e);
        }
    }

    public int getFunctionCount() {
        return this.functions.size(false);
    }

    public boolean removeFunction(Address entryPoint) {
        try (LockHold hold = this.program.trace.lockWrite();){
            TraceFunctionSymbol at = this.getFunctionAt(entryPoint);
            if (at == null) {
                boolean bl = false;
                return bl;
            }
            at.delete();
            boolean bl = true;
            return bl;
        }
    }

    public TraceFunctionSymbol getFunctionAt(Address entryPoint) {
        if (!entryPoint.getAddressSpace().isMemorySpace()) {
            return null;
        }
        for (long s : this.program.viewport.getOrderedSnaps()) {
            Iterator iterator = this.functions.getAt(s, null, entryPoint, false).iterator();
            if (!iterator.hasNext()) continue;
            TraceFunctionSymbol at = (TraceFunctionSymbol)iterator.next();
            if (entryPoint.equals((Object)at.getEntryPoint())) {
                return at;
            }
            return null;
        }
        return null;
    }

    public TraceFunctionSymbol getReferencedFunction(Address address) {
        if (!address.getAddressSpace().isMemorySpace()) {
            return null;
        }
        TraceFunctionSymbol found = this.getFunctionAt(address);
        if (found != null) {
            return found;
        }
        TraceData data = this.program.getTopCode(address, (space, s) -> (TraceData)space.data().getContaining((long)s, address));
        if (data == null) {
            return null;
        }
        DBTraceReference ref = this.program.trace.getReferenceManager().getPrimaryReferenceFrom(data.getStartSnap(), address, 0);
        return ref == null ? null : this.getFunctionAt(ref.getToAddress());
    }

    public TraceFunctionSymbol getFunctionContaining(Address addr) {
        Iterator iterator = this.functions.getAt(this.program.snap, null, addr, false).iterator();
        if (iterator.hasNext()) {
            TraceFunctionSymbol at = (TraceFunctionSymbol)iterator.next();
            return at;
        }
        return null;
    }

    protected Iterator<? extends DBTraceFunctionSymbol> getFunctionsInRange(AddressRange range, boolean forward) {
        return this.functions.getIntersecting((Range<Long>)Range.singleton((Comparable)Long.valueOf(this.program.snap)), null, range, false, forward).iterator();
    }

    public FunctionIterator getFunctions(boolean forward) {
        return this.getFunctions((AddressSetView)this.program.getAddressFactory().getAddressSet(), forward);
    }

    public FunctionIterator getFunctions(Address start, boolean forward) {
        return this.getFunctions(DBTraceUtils.getAddressSet(this.program.getAddressFactory(), start, forward), forward);
    }

    public FunctionIterator getFunctions(AddressSetView asv, boolean forward) {
        return new WrappingFunctionIterator(NestedIterator.start((Iterator)asv.iterator(forward), rng -> this.getFunctionsInRange((AddressRange)rng, forward)), f -> asv.contains(f.getEntryPoint()));
    }

    public FunctionIterator getFunctionsNoStubs(boolean forward) {
        return this.getFunctionsNoStubs((AddressSetView)this.program.getAddressFactory().getAddressSet(), forward);
    }

    public FunctionIterator getFunctionsNoStubs(Address start, boolean forward) {
        return this.getFunctionsNoStubs(DBTraceUtils.getAddressSet(this.program.getAddressFactory(), start, forward), forward);
    }

    public FunctionIterator getFunctionsNoStubs(AddressSetView asv, boolean forward) {
        return new WrappingFunctionIterator(NestedIterator.start((Iterator)asv.iterator(forward), rng -> this.getFunctionsInRange((AddressRange)rng, forward)), f -> {
            if (f.isThunk()) {
                return false;
            }
            if (!asv.contains(f.getEntryPoint())) {
                return false;
            }
            return this.program.trace.getCodeManager().instructions().getAt(this.program.snap, f.getEntryPoint()) != null;
        });
    }

    public FunctionIterator getExternalFunctions() {
        return EmptyFunctionIterator.INSTANCE;
    }

    public boolean isInFunction(Address addr) {
        return this.getFunctionContaining(addr) != null;
    }

    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        throw new UnsupportedOperationException();
    }

    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        Iterator<? extends DBTraceFunctionSymbol> it = this.getFunctionsInRange((AddressRange)new AddressRangeImpl(startAddr, endAddr), true);
        while (it.hasNext()) {
            monitor.checkCanceled();
            it.next().delete();
        }
    }

    public void setProgram(ProgramDB program) {
        throw new UnsupportedOperationException();
    }

    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public void invalidateCache(boolean all) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Function> getFunctionsOverlapping(AddressSetView set) {
        return new WrappingFunctionIterator(NestedIterator.start((Iterator)set.iterator(true), rng -> this.getFunctionsInRange((AddressRange)rng, true)));
    }

    public Variable getReferencedVariable(Address instrAddr, Address storageAddr, int size, boolean isRead) {
        TraceFunctionSymbol function = this.getFunctionContaining(instrAddr);
        if (function == null) {
            return null;
        }
        return DBTraceFunctionSymbolView.getReferencedVariable(function, instrAddr, storageAddr, size, isRead, this.program.language);
    }

    public TraceFunctionSymbol getFunction(long key) {
        return (TraceFunctionSymbol)this.functions.getByKey(key);
    }
}

