/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.space;

import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;

public interface DBTraceSpaceKey
extends TraceAddressSpace {
    public static DBTraceSpaceKey create(AddressSpace space, TraceThread thread, int frameLevel) {
        return new DefaultDBTraceSpaceKey(thread, space, frameLevel);
    }

    public static class DefaultDBTraceSpaceKey
    implements DBTraceSpaceKey {
        private final TraceThread thread;
        private final AddressSpace space;
        private final int frameLevel;

        private DefaultDBTraceSpaceKey(TraceThread thread, AddressSpace space, int frameLevel) {
            this.thread = thread;
            this.space = space;
            this.frameLevel = frameLevel;
        }

        @Override
        public AddressSpace getAddressSpace() {
            return this.space;
        }

        @Override
        public TraceThread getThread() {
            return this.thread;
        }

        @Override
        public int getFrameLevel() {
            return this.frameLevel;
        }
    }
}

