/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import java.util.List;

public class DBTraceObjectStackFrame
implements TraceObjectStackFrame,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private RangeSet<Long> life = TreeRangeSet.create();

    public DBTraceObjectStackFrame(DBTraceObject object) {
        this.object = object;
    }

    @Override
    public TraceObjectStack getStack() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceObjectStack traceObjectStack = this.object.queryCanonicalAncestorsInterface(TraceObjectStack.class).findAny().orElseThrow();
            return traceObjectStack;
        }
    }

    @Override
    public int getLevel() {
        List<String> keys = this.object.getCanonicalPath().getKeyList();
        for (int i = keys.size() - 1; i >= 0; --i) {
            String k = keys.get(i);
            if (!PathUtils.isIndex((String)k)) continue;
            String index = PathUtils.parseIndex((String)k);
            try {
                return Integer.decode(index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Frame has no index!?");
    }

    @Override
    public Address getProgramCounter(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_pc", Address.class, null);
    }

    @Override
    public void setProgramCounter(Range<Long> span, Address pc) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            if (pc == Address.NO_ADDRESS) {
                pc = null;
            }
            this.object.setValue(span, "_pc", pc);
        }
    }

    @Override
    public String getComment(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Address pc = this.getProgramCounter(snap);
            String string = pc == null ? null : this.object.getTrace().getCommentAdapter().getComment(snap, pc, 0);
            return string;
        }
    }

    @Override
    public void setComment(long snap, String comment) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            InternalTraceObjectValue pcAttr = this.object.getValue(snap, "_pc");
            this.object.getTrace().getCommentAdapter().setComment(pcAttr.getLifespan(), (Address)pcAttr.getValue(), 0, comment);
        }
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    protected boolean changeApplies(TraceChangeRecord<?, ?> rec) {
        TraceChangeRecord cast = Trace.TraceObjectChangeType.VALUE_CREATED.cast(rec);
        TraceObjectValue affected = (TraceObjectValue)cast.getAffectedObject();
        assert (affected.getParent() == this.object);
        if (!"_pc".equals(affected.getEntryKey())) {
            return false;
        }
        return this.object.getCanonicalParent(affected.getMaxSnap()) != null;
    }

    @Override
    public Range<Long> computeSpan() {
        Range<Long> span = DBTraceObjectInterface.super.computeSpan();
        if (span != null) {
            return span;
        }
        return this.getStack().computeSpan();
    }

    protected long snapFor(TraceChangeRecord<?, ?> rec) {
        if (rec.getEventType() == Trace.TraceObjectChangeType.VALUE_CREATED.getType()) {
            return ((TraceObjectValue)Trace.TraceObjectChangeType.VALUE_CREATED.cast(rec).getAffectedObject()).getMinSnap();
        }
        return this.computeMinSnap();
    }

    protected TraceChangeRecord<?, ?> createChangeRecord() {
        return new TraceChangeRecord<TraceObjectStack, Long>(Trace.TraceStackChangeType.CHANGED, null, this.getStack(), 0L, DBTraceUtils.lowerEndpoint((Range<Long>)this.life.span()));
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        int type = rec.getEventType();
        if (type == Trace.TraceObjectChangeType.LIFE_CHANGED.getType()) {
            RangeSet<Long> newLife = this.object.getLife();
            if (!newLife.isEmpty()) {
                this.life = newLife;
            }
            return this.createChangeRecord();
        }
        if (type == Trace.TraceObjectChangeType.VALUE_CREATED.getType() && this.changeApplies(rec)) {
            return this.createChangeRecord();
        }
        if (type == Trace.TraceObjectChangeType.DELETED.getType()) {
            if (this.life.isEmpty()) {
                return null;
            }
            return this.createChangeRecord();
        }
        return null;
    }
}

