/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.Collections2;
import generic.CatenatedCollection;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeView;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.symbol.TraceSymbolView;
import java.util.Arrays;
import java.util.Collection;

public class DBTraceSymbolMultipleTypesView<T extends AbstractDBTraceSymbol>
implements TraceSymbolView<T> {
    protected final DBTraceSymbolManager manager;
    protected final Collection<? extends AbstractDBTraceSymbolSingleTypeView<? extends T>> parts;

    public DBTraceSymbolMultipleTypesView(DBTraceSymbolManager manager, Collection<? extends AbstractDBTraceSymbolSingleTypeView<? extends T>> parts) {
        this.manager = manager;
        this.parts = parts;
    }

    @Override
    public TraceSymbolManager getManager() {
        return this.manager;
    }

    @SafeVarargs
    public DBTraceSymbolMultipleTypesView(DBTraceSymbolManager manager, AbstractDBTraceSymbolSingleTypeView<? extends T> ... parts) {
        this(manager, Arrays.asList(parts));
    }

    @Override
    public Collection<? extends T> getAll(boolean includeDynamicSymbols) {
        return new CatenatedCollection(Collections2.transform(this.parts, p -> p.getAll(includeDynamicSymbols)));
    }

    @Override
    public Collection<? extends T> getChildrenNamed(String name, TraceNamespaceSymbol parent) {
        return new CatenatedCollection(Collections2.transform(this.parts, p -> p.getChildrenNamed(name, parent)));
    }

    @Override
    public Collection<? extends T> getChildren(TraceNamespaceSymbol parent) {
        return new CatenatedCollection(Collections2.transform(this.parts, p -> p.getChildren(parent)));
    }

    @Override
    public Collection<? extends T> getNamed(String name) {
        return new CatenatedCollection(Collections2.transform(this.parts, p -> p.getNamed(name)));
    }

    @Override
    public Collection<? extends T> getWithMatchingName(String glob, boolean caseSensitive) {
        return new CatenatedCollection(Collections2.transform(this.parts, p -> p.getWithMatchingName(glob, caseSensitive)));
    }
}

