/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapSpace;
import ghidra.util.database.spatial.rect.EuclideanSpace2D;

public class ImmutableTraceAddressSnapRange
implements TraceAddressSnapRange {
    protected final AddressRange range;
    protected final Range<Long> lifespan;
    protected final EuclideanSpace2D<Address, Long> space;

    public static AddressRange rangeCentered(Address address, int breadth) {
        AddressSpace space = address.getAddressSpace();
        Address min = Long.compareUnsigned(address.subtract(space.getMinAddress()), breadth) <= 0 ? space.getMinAddress() : address.subtract((long)breadth);
        Address max = Long.compareUnsigned(space.getMaxAddress().subtract(address), breadth) <= 0 ? space.getMaxAddress() : address.add((long)breadth);
        return new AddressRangeImpl(min, max);
    }

    public static Range<Long> spanCentered(long snap, int breadth) {
        long min = Long.compareUnsigned(snap - Long.MIN_VALUE, breadth) <= 0 ? Long.MIN_VALUE : snap - (long)breadth;
        long max = Long.compareUnsigned(Long.MAX_VALUE - snap, breadth) <= 0 ? Long.MAX_VALUE : snap + (long)breadth;
        return Range.closed((Comparable)Long.valueOf(min), (Comparable)Long.valueOf(max));
    }

    public static ImmutableTraceAddressSnapRange centered(Address address, long snap, int addressBreadth, int snapBreadth) {
        return new ImmutableTraceAddressSnapRange(ImmutableTraceAddressSnapRange.rangeCentered(address, addressBreadth), ImmutableTraceAddressSnapRange.spanCentered(snap, snapBreadth));
    }

    public ImmutableTraceAddressSnapRange(Address minAddress, Address maxAddress, long minSnap, long maxSnap, TraceAddressSnapSpace space) {
        this.range = new AddressRangeImpl(minAddress, maxAddress);
        this.lifespan = DBTraceUtils.toRange(minSnap, maxSnap);
        this.space = space;
    }

    public ImmutableTraceAddressSnapRange(Address minAddress, Address maxAddress, long minSnap, long maxSnap) {
        this.range = new AddressRangeImpl(minAddress, maxAddress);
        this.lifespan = DBTraceUtils.toRange(minSnap, maxSnap);
        this.space = TraceAddressSnapSpace.forAddressSpace(minAddress.getAddressSpace());
    }

    public ImmutableTraceAddressSnapRange(AddressRange range, Range<Long> lifespan) {
        this.range = range;
        this.lifespan = lifespan;
        this.space = TraceAddressSnapSpace.forAddressSpace(range.getAddressSpace());
    }

    public ImmutableTraceAddressSnapRange(AddressRange range, long snap) {
        this.range = range;
        this.lifespan = DBTraceUtils.toRange(snap, snap);
        this.space = TraceAddressSnapSpace.forAddressSpace(range.getAddressSpace());
    }

    public ImmutableTraceAddressSnapRange(Address minAddress, Address maxAddress, Range<Long> lifespan, EuclideanSpace2D<Address, Long> space) {
        this.range = new AddressRangeImpl(minAddress, maxAddress);
        this.lifespan = lifespan;
        this.space = space;
    }

    public ImmutableTraceAddressSnapRange(Address minAddress, Address maxAddress, Range<Long> lifespan) {
        this.range = new AddressRangeImpl(minAddress, maxAddress);
        this.lifespan = lifespan;
        this.space = TraceAddressSnapSpace.forAddressSpace(this.range.getAddressSpace());
    }

    public ImmutableTraceAddressSnapRange(Address address, Range<Long> lifespan) {
        this.range = new AddressRangeImpl(address, address);
        this.lifespan = lifespan;
        this.space = TraceAddressSnapSpace.forAddressSpace(address.getAddressSpace());
    }

    public ImmutableTraceAddressSnapRange(Address address, long snap) {
        this.range = new AddressRangeImpl(address, address);
        this.lifespan = DBTraceUtils.toRange(snap, snap);
        this.space = TraceAddressSnapSpace.forAddressSpace(address.getAddressSpace());
    }

    public boolean equals(Object obj) {
        return this.doEquals(obj);
    }

    public int hashCode() {
        return this.doHashCode();
    }

    public String toString() {
        return this.description();
    }

    @Override
    public AddressRange getRange() {
        return this.range;
    }

    @Override
    public Range<Long> getLifespan() {
        return this.lifespan;
    }

    public EuclideanSpace2D<Address, Long> getSpace() {
        return this.space;
    }
}

