/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.breakpoint;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.set.AbstractSetDecorator;

public enum TraceBreakpointKind {
    READ(1),
    WRITE(2),
    HW_EXECUTE(4),
    SW_EXECUTE(8);

    private final byte bits;

    private TraceBreakpointKind(int mask) {
        this.bits = (byte)mask;
    }

    public byte getBits() {
        return this.bits;
    }

    public static class TraceBreakpointKindSet
    extends AbstractSetDecorator<TraceBreakpointKind> {
        public static final TraceBreakpointKindSet SW_EXECUTE = TraceBreakpointKindSet.of(SW_EXECUTE);
        public static final TraceBreakpointKindSet HW_EXECUTE = TraceBreakpointKindSet.of(HW_EXECUTE);
        public static final TraceBreakpointKindSet READ = TraceBreakpointKindSet.of(READ);
        public static final TraceBreakpointKindSet WRITE = TraceBreakpointKindSet.of(WRITE);
        public static final TraceBreakpointKindSet ACCESS = TraceBreakpointKindSet.of(READ, WRITE);

        public static TraceBreakpointKindSet of(TraceBreakpointKind ... kinds) {
            return new TraceBreakpointKindSet(Set.of(kinds));
        }

        public static TraceBreakpointKindSet copyOf(Collection<TraceBreakpointKind> kinds) {
            return new TraceBreakpointKindSet(Set.copyOf(kinds));
        }

        public static TraceBreakpointKindSet decode(String encoded, boolean strict) {
            EnumSet<TraceBreakpointKind> result = EnumSet.noneOf(TraceBreakpointKind.class);
            HashSet<String> names = new HashSet<String>(Set.of(encoded.toUpperCase().split(",")));
            for (TraceBreakpointKind k : TraceBreakpointKind.values()) {
                if (!names.remove(k.name())) continue;
                result.add(k);
            }
            if (strict && !names.isEmpty()) {
                throw new IllegalArgumentException(((Object)names).toString());
            }
            return new TraceBreakpointKindSet(result);
        }

        public static String encode(Collection<TraceBreakpointKind> col) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (TraceBreakpointKind k : TraceBreakpointKind.values()) {
                if (!col.contains((Object)k)) continue;
                if (!first) {
                    sb.append(',');
                }
                first = false;
                sb.append(k.name());
            }
            return sb.toString();
        }

        public TraceBreakpointKindSet(Set<TraceBreakpointKind> set) {
            super(set);
        }

        public String toString() {
            return TraceBreakpointKindSet.encode((Collection<TraceBreakpointKind>)((Object)this));
        }
    }
}

