/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.module.DBTraceModuleSpace;
import ghidra.trace.database.module.DBTraceSection;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceModule
extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceModule>
implements TraceModule {
    static final String TABLE_NAME = "Modules";
    static final String PATH_COLUMN_NAME = "Path";
    static final String NAME_COLUMN_NAME = "Name";
    @DBAnnotatedColumn(value="Path")
    static DBObjectColumn PATH_COLUMN;
    @DBAnnotatedColumn(value="Name")
    static DBObjectColumn NAME_COLUMN;
    @DBAnnotatedField(column="Path", indexed=true)
    String path;
    @DBAnnotatedField(column="Name")
    String name;
    final DBTraceModuleSpace space;

    static String tableName(AddressSpace space) {
        return DBTraceUtils.tableName(TABLE_NAME, space, -1L, 0);
    }

    public DBTraceModule(DBTraceModuleSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceModule, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(tree, store, record);
        this.space = space;
    }

    protected void setRecordValue(DBTraceModule value) {
    }

    protected DBTraceModule getRecordValue() {
        return this;
    }

    void set(String path, String name) {
        this.path = path;
        this.name = name;
        this.update(PATH_COLUMN, NAME_COLUMN);
    }

    @Override
    public DBTrace getTrace() {
        return this.space.trace;
    }

    @Override
    public DBTraceSection addSection(String sectionPath, String sectionName, AddressRange range) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            DBTraceSection dBTraceSection = this.space.manager.doAddSection(this, sectionPath, sectionName, range);
            return dBTraceSection;
        }
    }

    @Override
    public String getPath() {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.readLock());){
            String string = this.path;
            return string;
        }
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            if (Objects.equals(this.name, name)) {
                return;
            }
            this.name = name;
            this.update(NAME_COLUMN);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceModuleChangeType.CHANGED, null, this));
    }

    @Override
    public String getName() {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.readLock());){
            String string = this.name;
            return string;
        }
    }

    @Override
    public void setRange(AddressRange range) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            if (this.range.equals(range)) {
                return;
            }
            this.doSetRange(range);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceModuleChangeType.CHANGED, this.space, this));
    }

    @Override
    public void setBase(Address base) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            this.setRange(DBTraceUtils.toRange(base, this.range.getMaxAddress()));
        }
    }

    @Override
    public Address getBase() {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.readLock());){
            Address address = this.range.getMinAddress();
            return address;
        }
    }

    @Override
    public void setMaxAddress(Address max) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            this.setRange(DBTraceUtils.toRange(this.range.getMinAddress(), max));
        }
    }

    @Override
    public Address getMaxAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address address = this.range.getMaxAddress();
            return address;
        }
    }

    @Override
    public void setLength(long length) throws AddressOverflowException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            Address base = this.range.getMinAddress();
            this.setRange(DBTraceUtils.toRange(base, base.addNoWrap(length - 1L)));
        }
    }

    @Override
    public long getLength() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            long l = this.range.getLength();
            return l;
        }
    }

    @Override
    public void setLifespan(Lifespan newLifespan) throws DuplicateNameException {
        Lifespan oldLifespan;
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            this.space.manager.checkModulePathConflicts(this, this.path, newLifespan);
            ArrayList<? extends DBTraceSection> sections = new ArrayList<DBTraceSection>(this.getSections());
            for (DBTraceSection dBTraceSection : sections) {
                this.space.manager.checkSectionPathConflicts(dBTraceSection, dBTraceSection.getPath(), newLifespan);
            }
            oldLifespan = this.lifespan;
            this.doSetLifespan(newLifespan);
            for (DBTraceSection dBTraceSection : sections) {
                dBTraceSection.doSetLifespan(newLifespan);
            }
        }
        this.space.trace.setChanged(new TraceChangeRecord<DBTraceModule, Lifespan>(Trace.TraceModuleChangeType.LIFESPAN_CHANGED, null, this, oldLifespan, newLifespan));
    }

    @Override
    public Lifespan getLifespan() {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.readLock());){
            Lifespan lifespan = this.lifespan;
            return lifespan;
        }
    }

    @Override
    public void setLoadedSnap(long loadedSnap) throws DuplicateNameException {
        this.setLifespan(Lifespan.span(loadedSnap, this.getUnloadedSnap()));
    }

    @Override
    public long getLoadedSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.readLock());){
            long l = this.lifespan.lmin();
            return l;
        }
    }

    @Override
    public void setUnloadedSnap(long unloadedSnap) throws DuplicateNameException {
        this.setLifespan(Lifespan.span(this.getLoadedSnap(), unloadedSnap));
    }

    @Override
    public long getUnloadedSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.readLock());){
            long l = this.lifespan.lmax();
            return l;
        }
    }

    public Collection<? extends DBTraceSection> getSections() {
        return this.space.manager.doGetSectionsByModuleId(this.getKey());
    }

    @Override
    public TraceSection getSectionByName(String sectionName) {
        return this.space.manager.doGetSectionByName(this.getKey(), sectionName);
    }

    @Override
    public void delete() {
        this.space.manager.doDeleteModule(this);
    }
}

