/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import agent.gdb.manager.GdbModule;
import agent.gdb.manager.GdbModuleSection;
import agent.gdb.manager.impl.GdbInferiorImpl;
import agent.gdb.manager.impl.GdbMinimalSymbol;
import agent.gdb.manager.impl.GdbModuleSectionImpl;
import agent.gdb.manager.impl.cmd.GdbConsoleExecCommand;
import ghidra.async.AsyncLazyValue;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GdbModuleImpl
implements GdbModule {
    protected static final String MAINT_INFO_SECTIONS_CMD_V8 = "maintenance info sections ALLOBJ";
    protected static final String MAINT_INFO_SECTIONS_CMD_V11 = "maintenance info sections -all-objects";
    protected static final String[] MAINT_INFO_SECTIONS_CMDS = new String[]{"maintenance info sections -all-objects", "maintenance info sections ALLOBJ"};
    protected static final Pattern OBJECT_FILE_LINE_PATTERN_V8 = Pattern.compile("\\s*Object file: (?<name>.*)");
    protected static final Pattern OBJECT_FILE_LINE_PATTERN_V11 = Pattern.compile("\\s*((Object)|(Exec)) file: `(?<name>.*)', file type (?<type>.*)");
    protected static final Pattern[] OBJECT_FILE_LINE_PATTERNS = new Pattern[]{OBJECT_FILE_LINE_PATTERN_V11, OBJECT_FILE_LINE_PATTERN_V8};
    protected static final String GNU_DEBUGDATA_PREFIX = ".gnu_debugdata for ";
    protected static final Pattern OBJECT_SECTION_LINE_PATTERN_V8 = Pattern.compile("\\s*0x(?<vmaS>[0-9A-Fa-f]+)\\s*->\\s*0x(?<vmaE>[0-9A-Fa-f]+)\\s+at\\s+0x(?<offset>[0-9A-Fa-f]+)\\s*:\\s*(?<name>\\S+)\\s+(?<attrs>.*)");
    protected static final Pattern OBJECT_SECTION_LINE_PATTERN_V10 = Pattern.compile("\\s*\\[\\s*(?<idx>\\d+)\\]\\s+0x(?<vmaS>[0-9A-Fa-f]+)\\s*->\\s*0x(?<vmaE>[0-9A-Fa-f]+)\\s+at\\s+0x(?<offset>[0-9A-Fa-f]+)\\s*:\\s*(?<name>\\S+)\\s+(?<attrs>.*)");
    protected static final Pattern[] OBJECT_SECTION_LINE_PATTERNS = new Pattern[]{OBJECT_SECTION_LINE_PATTERN_V10, OBJECT_SECTION_LINE_PATTERN_V8};
    protected static final Pattern MSYMBOL_LINE_PATTERN = Pattern.compile("\\s*\\[\\s*(?<idx>\\d+)\\]\\s+(?<type>\\S+)\\s+0x(?<addr>[0-9A-Fa-f]+)\\s+(?<name>\\S+)\\s+.*");
    protected final GdbInferiorImpl inferior;
    protected final String name;
    protected Long base = null;
    protected Long max = null;
    protected final Map<String, GdbModuleSectionImpl> sections = new LinkedHashMap<String, GdbModuleSectionImpl>();
    protected final Map<String, GdbModuleSection> unmodifiableSections = Collections.unmodifiableMap(this.sections);
    protected final AsyncLazyValue<Map<String, GdbMinimalSymbol>> minimalSymbols = new AsyncLazyValue(this::doGetMinimalSymbols);

    public GdbModuleImpl(GdbInferiorImpl inferior, String name) {
        this.inferior = inferior;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getBase() {
        return this.base;
    }

    @Override
    public Long getMax() {
        return this.max;
    }

    @Override
    public CompletableFuture<Map<String, GdbModuleSection>> listSections(boolean refresh) {
        return this.inferior.listModules(refresh).thenApply(__ -> this.unmodifiableSections);
    }

    @Override
    public Map<String, GdbModuleSection> getKnownSections() {
        return this.unmodifiableSections;
    }

    protected CompletableFuture<Map<String, GdbMinimalSymbol>> doGetMinimalSymbols() {
        String cmd = "maintenance print msymbols -objfile " + this.name;
        return this.inferior.consoleCapture(cmd, GdbConsoleExecCommand.CompletesWithRunning.CANNOT).thenApply(out -> {
            LinkedHashMap<String, GdbMinimalSymbol> result = new LinkedHashMap<String, GdbMinimalSymbol>();
            for (String line : out.split("\n")) {
                Matcher mat = MSYMBOL_LINE_PATTERN.matcher(line);
                if (!mat.matches()) continue;
                long index = Long.parseLong(mat.group("idx"));
                String type = Objects.requireNonNull(mat.group("type"));
                long address = Long.parseLong(mat.group("addr"), 16);
                String symName = Objects.requireNonNull(mat.group("name"));
                result.put(symName, new GdbMinimalSymbol(index, type, symName, address));
            }
            return Collections.unmodifiableMap(result);
        });
    }

    @Override
    public CompletableFuture<Map<String, GdbMinimalSymbol>> listMinimalSymbols() {
        return this.minimalSymbols.request();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processSectionLine(String line, Set<String> namesSeen) {
        Matcher matcher = this.inferior.manager.matchSectionLine(line);
        if (matcher == null) return;
        try {
            long vmaStart = Long.parseLong(matcher.group("vmaS"), 16);
            long vmaEnd = Long.parseLong(matcher.group("vmaE"), 16);
            long offset = Long.parseLong(matcher.group("offset"), 16);
            String sectionName = matcher.group("name");
            namesSeen.add(sectionName);
            ArrayList<String> attrs = new ArrayList<String>();
            for (String a : matcher.group("attrs").split("\\s+")) {
                if (a.length() == 0) continue;
                attrs.add(a);
            }
            if (attrs.contains("ALLOC")) {
                long b = vmaStart - offset;
                this.base = this.base == null ? b : MathUtilities.unsignedMin((long)this.base, (long)b);
                this.max = this.max == null ? b : MathUtilities.unsignedMax((long)this.max, (long)vmaEnd);
            }
            if (this.sections.put(sectionName, new GdbModuleSectionImpl(sectionName, vmaStart, vmaEnd, offset, attrs)) == null) return;
        }
        catch (NumberFormatException e) {
            Msg.error((Object)this, (Object)("Invalid number in section entry: " + line));
        }
    }

    protected void resyncRetainSections(Set<String> names) {
        this.sections.keySet().retainAll(names);
    }
}

