/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBModule;
import SWIG.SBTarget;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LldbListModulesCommand
extends AbstractLldbCommand<Map<String, SBModule>> {
    protected final SBTarget session;
    private Map<String, SBModule> updatedModules = new HashMap<String, SBModule>();

    public LldbListModulesCommand(LldbManagerImpl manager, SBTarget session) {
        super(manager);
        this.session = session;
    }

    @Override
    public Map<String, SBModule> complete(LldbPendingCommand<?> pending) {
        Map<String, SBModule> modules = this.manager.getKnownModules(this.session);
        Set<String> cur = modules.keySet();
        for (String id : this.updatedModules.keySet()) {
            if (cur.contains(id)) continue;
            this.manager.addModuleIfAbsent(this.session, this.updatedModules.get(id));
        }
        for (String id : new ArrayList<String>(cur)) {
            if (this.updatedModules.containsKey(id)) continue;
            this.manager.removeModule(this.session, id);
        }
        return this.manager.getKnownModules(this.session);
    }

    @Override
    public void invoke() {
        long n = this.session.GetNumModules();
        int i = 0;
        while ((long)i < n) {
            SBModule module = this.session.GetModuleAtIndex((long)i);
            this.updatedModules.put(DebugClient.getId(module), module);
            ++i;
        }
    }
}

