/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaSymbol;
import agent.frida.model.iface2.FridaModelTargetSymbolContainer;
import agent.frida.model.impl.FridaModelTargetModuleImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetSymbolImpl;
import agent.frida.model.methods.FridaModelTargetSymbolFromAddressImpl;
import agent.frida.model.methods.FridaModelTargetSymbolFromNameImpl;
import agent.frida.model.methods.FridaModelTargetSymbolLoadImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="SymbolContainer", elements={@TargetElementType(type=FridaModelTargetSymbolImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetSymbolContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetSymbolContainer {
    protected final FridaModelTargetModuleImpl module;
    private FridaModelTargetSymbolFromAddressImpl fromAddr;
    private FridaModelTargetSymbolFromNameImpl fromName;
    private FridaModelTargetSymbolLoadImpl load;

    public FridaModelTargetSymbolContainerImpl(FridaModelTargetModuleImpl module) {
        super(module.getModel(), (TargetObject)module, "Symbols", "SymbolContainer");
        this.module = module;
        this.fromAddr = new FridaModelTargetSymbolFromAddressImpl(this);
        this.fromName = new FridaModelTargetSymbolFromNameImpl(this);
        this.load = new FridaModelTargetSymbolLoadImpl(this);
        this.changeAttributes(List.of(), List.of(this.fromAddr, this.fromName, this.load), Map.of(), "Initialized");
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listModuleSymbols(this.module.getModule()).thenAccept(byName -> {
            List symbols;
            FridaModelTargetSymbolContainerImpl fridaModelTargetSymbolContainerImpl = this;
            synchronized (fridaModelTargetSymbolContainerImpl) {
                symbols = byName.values().stream().map(this::getTargetSymbol).collect(Collectors.toList());
            }
            this.setElements(symbols, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized FridaModelTargetSymbolImpl getTargetSymbol(FridaSymbol symbol) {
        TargetObject targetObject = this.getMapObject(symbol);
        if (targetObject != null) {
            FridaModelTargetSymbolImpl targetSymbol = (FridaModelTargetSymbolImpl)targetObject;
            targetSymbol.setModelObject(symbol);
            return targetSymbol;
        }
        return new FridaModelTargetSymbolImpl(this, symbol);
    }
}

