/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import db.Transaction;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.pcode.struct.LValInternal;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.lang.PcodeParser;

class DefaultVar
implements LValInternal,
StructuredSleigh.Var {
    protected final StructuredSleigh ctx;
    protected final String name;
    protected final DataType type;

    protected DefaultVar(StructuredSleigh ctx, Check check, String name, DataType type) {
        check.check(ctx.parser, name);
        this.ctx = ctx;
        this.name = name;
        try (Transaction tx = ctx.dtm.openTransaction("Resolve type");){
            this.type = ctx.dtm.resolve(type, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
    }

    @Override
    public StructuredSleigh.Var cast(DataType type) {
        return new DefaultVar(this.ctx, Check.NONE, this.name, type);
    }

    public String toString() {
        return "<" + this.getClass().getSimpleName() + ": " + this.name + " : " + this.type + ">";
    }

    @Override
    public StructuredSleigh getContext() {
        return this.ctx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public StringTree generate(RValInternal parent) {
        return StringTree.single(this.name);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Check {
        NONE{

            @Override
            void check(PcodeParser parser, String name) {
            }
        }
        ,
        IMPORT{

            @Override
            void check(PcodeParser parser, String name) {
                SleighSymbol symbol = parser.findSymbol(name);
                if (symbol == null) {
                    throw new SleighException("Missing symbol '" + name + "'");
                }
            }
        }
        ,
        FREE{

            @Override
            void check(PcodeParser parser, String name) {
                SleighSymbol symbol = parser.findSymbol(name);
                if (symbol != null) {
                    throw new SleighException("Duplicate symbol '" + name + "': Already defined by the language");
                }
            }
        };


        abstract void check(PcodeParser var1, String var2);
    }
}

