/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.apple8900;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.crypto.DecryptedPacket;
import ghidra.file.formats.ios.apple8900.Apple8900Constants;
import ghidra.file.formats.ios.apple8900.Apple8900Decryptor;
import ghidra.file.formats.ios.apple8900.Apple8900Header;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@FileSystemInfo(type="apple8900", description="Apple 8900", factory=GFileSystemBaseFactory.class)
public class Apple8900FileSystem
extends GFileSystemBase {
    private GFileImpl dataFile;

    public Apple8900FileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void close() throws IOException {
        this.dataFile = null;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        if (file != null && file.equals(this.dataFile)) {
            return this.fsService.getDerivedByteProvider(this.provider.getFSRL(), file.getFSRL(), file.getName(), -1L, () -> {
                Apple8900Decryptor decryptor = new Apple8900Decryptor();
                DecryptedPacket decrypt = decryptor.decrypt(null, null, this.provider, monitor);
                return decrypt.decryptedStream;
            }, monitor);
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        if (directory == null || directory.equals(this.root)) {
            tmp.add((GFile)this.dataFile);
        }
        return tmp;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] magic = this.provider.readBytes(0L, (long)Apple8900Constants.MAGIC_LENGTH);
        return Arrays.equals(magic, Apple8900Constants.MAGIC_BYTES);
    }

    public void open(TaskMonitor monitor) throws IOException {
        Apple8900Header header = new Apple8900Header(this.provider);
        if (!header.getMagic().equals("8900")) {
            throw new IOException("Unable to decrypt file: invalid Apple 8900 file!");
        }
        this.dataFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"DATA", (boolean)false, (long)header.getSizeOfData(), null);
    }
}

