/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.URLLinkObject;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.FileSystem;
import ghidra.program.database.DataTypeArchiveContentHandler;
import ghidra.program.database.DataTypeArchiveDB;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.Icon;

public class DataTypeArchiveLinkContentHandler
extends LinkHandler<DataTypeArchiveDB> {
    public static final String ARCHIVE_LINK_CONTENT_TYPE = "ArchiveLink";

    public long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject obj, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        if (!(obj instanceof URLLinkObject)) {
            throw new IOException("Unsupported domain object: " + obj.getClass().getName());
        }
        return this.createFile((DomainObjectAdapterDB)((URLLinkObject)obj), ARCHIVE_LINK_CONTENT_TYPE, fs, path, name, monitor);
    }

    public String getContentType() {
        return ARCHIVE_LINK_CONTENT_TYPE;
    }

    public String getContentTypeDisplayString() {
        return "Data Type Archive Link";
    }

    public Class<DataTypeArchiveDB> getDomainObjectClass() {
        return DataTypeArchiveContentHandler.DATA_TYPE_ARCHIVE_DOMAIN_OBJECT_CLASS;
    }

    public Icon getIcon() {
        return DataTypeArchiveContentHandler.DATA_TYPE_ARCHIVE_ICON;
    }

    public String getDefaultToolName() {
        return "CodeBrowser";
    }
}

