/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.CallingConventionDBAdapter;
import ghidra.util.Msg;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

class CallingConventionDBAdapterV0
extends CallingConventionDBAdapter {
    private static final int VERSION = 0;
    static final int V0_CALLING_CONVENTION_NAME_COL = 0;
    static final Schema V0_CALLING_CONVENTION_SCHEMA = new Schema(0, (Field)ByteField.INSTANCE, "ID", new Field[]{StringField.INSTANCE}, new String[]{"Name"});
    private Table callingConventionTable;
    private Map<String, Byte> callingConventionNameToIDMap;
    private Map<Byte, String> callingConventionIDToNameMap;
    private TreeRangeSet<Byte> freeKeySet;

    CallingConventionDBAdapterV0(DBHandle handle, String tablePrefix, boolean create) throws VersionException, IOException {
        String tableName = tablePrefix + "Calling Conventions";
        if (create) {
            this.callingConventionTable = handle.createTable(tableName, V0_CALLING_CONVENTION_SCHEMA, new int[0]);
        } else {
            this.callingConventionTable = handle.getTable(tableName);
            if (this.callingConventionTable == null) {
                throw new VersionException(true);
            }
            if (this.callingConventionTable.getSchema().getVersion() != 0) {
                throw new VersionException(false);
            }
        }
    }

    private byte removeFirstAvailableKey() {
        Iterator it = this.freeKeySet.asRanges().iterator();
        if (!it.hasNext()) {
            return -1;
        }
        Range r = (Range)it.next();
        it.remove();
        byte nextId = (Byte)r.lowerEndpoint();
        byte lastId = (Byte)r.upperEndpoint();
        if (nextId != lastId) {
            this.freeKeySet.add(Range.closed((Comparable)Byte.valueOf((byte)(nextId + 1)), (Comparable)Byte.valueOf(lastId)));
        }
        return nextId;
    }

    @Override
    void invalidateCache() {
        this.callingConventionNameToIDMap = null;
        this.callingConventionIDToNameMap = null;
        this.freeKeySet = null;
    }

    private void populateCache() throws IOException {
        if (this.callingConventionNameToIDMap != null) {
            return;
        }
        this.callingConventionNameToIDMap = new HashMap<String, Byte>();
        this.callingConventionIDToNameMap = new HashMap<Byte, String>();
        this.freeKeySet = TreeRangeSet.create();
        int nextKey = 2;
        for (DBRecord rec : this.callingConventionTable) {
            int id = (int)rec.getKey();
            String name = rec.getString(0);
            this.callingConventionIDToNameMap.put((byte)id, name);
            this.callingConventionNameToIDMap.put(name, (byte)id);
            if (nextKey != id) {
                this.freeKeySet.add(Range.closed((Comparable)Byte.valueOf((byte)nextKey), (Comparable)Byte.valueOf((byte)(id - 1))));
            }
            nextKey = id + 1;
        }
        if (nextKey <= 127) {
            this.freeKeySet.add(Range.closed((Comparable)Byte.valueOf((byte)nextKey), (Comparable)Byte.valueOf((byte)127)));
        }
    }

    @Override
    byte getCallingConventionId(String name, Consumer<String> conventionAdded) throws IOException {
        if (name == null || name.equals("unknown")) {
            return 0;
        }
        if (name.equals("default")) {
            return 1;
        }
        this.populateCache();
        Byte id = this.callingConventionNameToIDMap.get(name);
        if (id != null) {
            return id;
        }
        byte newId = this.removeFirstAvailableKey();
        if (newId < 0) {
            Msg.error((Object)this, (Object)("Unable to assign calling convention `" + name + "` - allocation capacity exceeded"));
            return 0;
        }
        DBRecord record = V0_CALLING_CONVENTION_SCHEMA.createRecord((Field)new ByteField(newId));
        record.setString(0, name);
        this.callingConventionTable.putRecord(record);
        this.callingConventionIDToNameMap.put(newId, name);
        this.callingConventionNameToIDMap.put(name, newId);
        conventionAdded.accept(name);
        return newId;
    }

    @Override
    String getCallingConventionName(byte id) throws IOException {
        if (id == 1) {
            return "default";
        }
        if (id == 0) {
            return null;
        }
        this.populateCache();
        return this.callingConventionIDToNameMap.get(id);
    }

    @Override
    Set<String> getCallingConventionNames() throws IOException {
        this.populateCache();
        return this.callingConventionNameToIDMap.keySet();
    }
}

