/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

class RecoverableAddressIterator
implements AddressIterator {
    private AddressSetView set;
    private boolean forward;
    private AddressIterator iterator;
    private Address next;

    RecoverableAddressIterator(AddressSetView set, Address start, boolean forward) {
        this.set = set;
        this.forward = forward;
        this.initIterator(start);
        this.next = this.iterator.next();
    }

    private void initIterator(Address start) {
        this.iterator = start == null ? this.set.getAddresses(this.forward) : this.set.getAddresses(start, this.forward);
    }

    @Override
    public Iterator<Address> iterator() {
        return this;
    }

    @Override
    public Address next() {
        Address addr = this.next;
        if (addr != null) {
            try {
                this.next = this.iterator.next();
            }
            catch (ConcurrentModificationException e) {
                this.next = this.recoverNext(addr);
            }
        }
        return addr;
    }

    private Address recoverNext(Address lastAddr) {
        while (true) {
            try {
                this.initIterator(lastAddr);
                Address a = this.iterator.next();
                if (a != null && a.equals(lastAddr)) {
                    a = this.iterator.next();
                }
                return a;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }
}

