/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import ghidra.program.database.module.ParentChildDBAdapterV0;
import ghidra.util.exception.VersionException;
import java.io.IOException;

abstract class ParentChildDBAdapter {
    private static final String PARENT_CHILD_TABLE_NAME = "Parent/Child Relationships";
    static final int PARENT_ID_COL = 0;
    static final int CHILD_ID_COL = 1;
    static final int ORDER_COL = 2;

    ParentChildDBAdapter() {
    }

    static ParentChildDBAdapter getAdapter(DBHandle handle, int openMode, long treeID) throws VersionException, IOException {
        return new ParentChildDBAdapterV0(handle, openMode == 0, treeID);
    }

    static final String getTableName(long treeID) {
        return PARENT_CHILD_TABLE_NAME + treeID;
    }

    abstract DBRecord addParentChildRecord(long var1, long var3) throws IOException;

    abstract DBRecord getParentChildRecord(long var1, long var3) throws IOException;

    abstract DBRecord getParentChildRecord(long var1) throws IOException;

    abstract void updateParentChildRecord(DBRecord var1) throws IOException;

    abstract boolean removeParentChildRecord(long var1) throws IOException;

    abstract Field[] getParentChildKeys(long var1, int var3) throws IOException;
}

