/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.ByteIngest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StringIngest
implements ByteIngest {
    private ByteArrayOutputStream outStream;
    private String source;
    private int maxBytes;

    public StringIngest() {
        this.outStream = null;
        this.source = null;
        this.maxBytes = 0;
    }

    public StringIngest(int max, String src) {
        this.open(max, src);
    }

    @Override
    public void open(int max, String src) {
        this.maxBytes = max;
        this.source = src;
        this.outStream = new ByteArrayOutputStream();
    }

    @Override
    public void ingestStream(InputStream inStream) throws IOException {
        int tok = inStream.read();
        while (tok > 0) {
            this.outStream.write(tok);
            if (this.outStream.size() >= this.maxBytes) {
                throw new IOException("Buffer size exceeded: " + this.source);
            }
            tok = inStream.read();
        }
    }

    @Override
    public void endIngest() {
    }

    @Override
    public void clear() {
        this.outStream = null;
        this.source = null;
    }

    public String toString() {
        if (this.outStream == null) {
            return "<empty>";
        }
        return this.outStream.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.outStream == null || this.outStream.size() == 0;
    }
}

