/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.AbstractCreateRttiDataModel;
import ghidra.app.cmd.data.rtti.Rtti3Model;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.Program;
import java.util.List;

public class Rtti4Model
extends AbstractCreateRttiDataModel {
    public static final String DATA_TYPE_NAME = "RTTICompleteObjectLocator";
    private static String STRUCTURE_NAME = "_s__RTTICompleteObjectLocator";
    private static final int SIGNATURE_ORDINAL = 0;
    private static final int VB_TABLE_OFFSET_ORDINAL = 1;
    private static final int CONSTRUCTOR_DISP_OFFSET_ORDINAL = 2;
    private static final int SIGNATURE_OFFSET = 0;
    private static final int VB_TABLE_OFFSET_OFFSET = 4;
    private static final int CONSTRUCTOR_DISP_OFFSET_OFFSET = 8;
    private static final int RTTI_0_PTR_OFFSET = 12;
    private static final int RTTI_3_PTR_OFFSET = 16;
    private DataType dataType;
    private TypeDescriptorModel rtti0Model;
    private Rtti3Model rtti3Model;

    public Rtti4Model(Program program, Address rtti4Address, DataValidationOptions validationOptions) {
        super(program, 1, rtti4Address, validationOptions);
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    public void validateModelSpecificInfo() throws InvalidDataTypeException {
        Program program = this.getProgram();
        Address startAddress = this.getAddress();
        boolean validateReferredToData = this.validationOptions.shouldValidateReferredToData();
        Address rtti0CompAddress = startAddress.add(12L);
        Address rtti0Address = MSDataTypeUtils.getReferencedAddress((Program)program, (Address)rtti0CompAddress);
        if (rtti0Address == null) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't refer to a valid location " + rtti0Address + " for the Type Descriptor.");
        }
        this.rtti0Model = new TypeDescriptorModel(program, rtti0Address, this.validationOptions);
        if (validateReferredToData) {
            this.rtti0Model.validate();
        } else if (!this.rtti0Model.isLoadedAndInitializedAddress()) {
            throw new InvalidDataTypeException("Data referencing " + this.rtti0Model.getName() + " data type isn't a loaded and initialized address " + rtti0Address + ".");
        }
        Address rtti3CompAddress = startAddress.add(16L);
        Address rtti3Address = MSDataTypeUtils.getReferencedAddress((Program)program, (Address)rtti3CompAddress);
        if (rtti3Address == null) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't refer to a valid location for the Class Hierarchy Descriptor.");
        }
        this.rtti3Model = new Rtti3Model(program, rtti3Address, this.validationOptions);
        if (validateReferredToData) {
            this.rtti3Model.validate();
        } else if (!this.rtti3Model.isLoadedAndInitializedAddress()) {
            throw new InvalidDataTypeException("Data referencing " + this.rtti3Model.getName() + " data type isn't a loaded and initialized address " + rtti3Address + ".");
        }
    }

    public static DataType getDataType(Program program) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
        StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)STRUCTURE_NAME);
        DWordDataType dWordDataType = new DWordDataType((DataTypeManager)dataTypeManager);
        struct.add((DataType)dWordDataType, "signature", null);
        struct.add((DataType)dWordDataType, "offset", "offset of vbtable within class");
        struct.add((DataType)dWordDataType, "cdOffset", "constructor displacement offset");
        DataType rtti0RefDt = MSDataTypeUtils.getReferenceDataType((Program)program, (DataType)TypeDescriptorModel.getDataType(program));
        struct.add(rtti0RefDt, "pTypeDescriptor", "ref to TypeDescriptor (RTTI 0) for class");
        DataType rtti3Dt = Rtti3Model.getDataType(program);
        DataType rtti3RefDt = MSDataTypeUtils.getReferenceDataType((Program)program, (DataType)rtti3Dt);
        struct.add(rtti3RefDt, "pClassDescriptor", "ref to ClassHierarchyDescriptor (RTTI 3)");
        TypedefDataType typedefDt = new TypedefDataType(categoryPath, DATA_TYPE_NAME, (DataType)struct, (DataTypeManager)dataTypeManager);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)typedefDt);
    }

    public static int getSignatureComponentOffset() {
        return 0;
    }

    public static int getVBTableComponentOffset() {
        return 4;
    }

    public static int getConstructorDisplacementComponentOffset() {
        return 8;
    }

    public static int getRtti0PointerComponentOffset() {
        return 12;
    }

    public static int getRtti3PointerComponentOffset() {
        return 16;
    }

    public Address getRtti0FieldAddress() throws InvalidDataTypeException {
        this.checkValidity();
        return this.getAddress().add(12L);
    }

    public Address getRtti3FieldAddress() throws InvalidDataTypeException {
        this.checkValidity();
        return this.getAddress().add(16L);
    }

    public int getSignature() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getIntegerValue(this.getDataType(), 0, this.getMemBuffer());
    }

    public int getVbTableOffset() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getIntegerValue(this.getDataType(), 1, this.getMemBuffer());
    }

    public int getConstructorOffset() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getIntegerValue(this.getDataType(), 2, this.getMemBuffer());
    }

    public Address getRtti0Address() throws InvalidDataTypeException {
        this.checkValidity();
        Address rtti0CompAddress = this.getAddress().add(12L);
        return MSDataTypeUtils.getReferencedAddress((Program)this.getProgram(), (Address)rtti0CompAddress);
    }

    public Address getRtti3Address() throws InvalidDataTypeException {
        this.checkValidity();
        Address rtti3CompAddress = this.getAddress().add(16L);
        return MSDataTypeUtils.getReferencedAddress((Program)this.getProgram(), (Address)rtti3CompAddress);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = Rtti4Model.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        return this.getDataType().getLength();
    }

    @Override
    public boolean refersToRtti0(Address rtti0Address) {
        try {
            this.checkValidity();
            Address rtti0AddressInRtti4 = this.getRtti0Address();
            if (rtti0AddressInRtti4 == null || !rtti0AddressInRtti4.equals((Object)rtti0Address)) {
                return false;
            }
            return this.rtti3Model.refersToRtti0(rtti0Address);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
    }

    public List<String> getBaseClassTypes() throws InvalidDataTypeException {
        this.checkValidity();
        return this.rtti3Model.getBaseClassTypes();
    }

    public TypeDescriptorModel getRtti0Model() throws InvalidDataTypeException {
        this.checkValidity();
        return this.rtti0Model;
    }

    public Rtti3Model getRtti3Model() throws InvalidDataTypeException {
        this.checkValidity();
        return this.rtti3Model;
    }
}

