/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.framework.Platform;
import java.io.FileNotFoundException;

public class OSFileNotFoundException
extends FileNotFoundException {
    private Platform platform;

    public OSFileNotFoundException(Platform platform, String moduleName, String fileName) {
        super(String.format("%sos/%s/%s does not exist", moduleName != null ? moduleName + "/" : "", platform.getDirectoryName(), fileName));
        this.platform = platform;
    }

    public OSFileNotFoundException(Platform platform, String fileName) {
        this(platform, null, fileName);
    }

    public OSFileNotFoundException(String moduleName, String fileName) {
        this(Platform.CURRENT_PLATFORM, moduleName, fileName);
    }

    public OSFileNotFoundException(String fileName) {
        this(Platform.CURRENT_PLATFORM, null, fileName);
    }

    public Platform getPlatform() {
        return this.platform;
    }
}

