/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.client;

import ghidra.framework.client.ClientAuthenticator;
import ghidra.framework.remote.AnonymousCallback;
import ghidra.framework.remote.SSHSignatureCallback;
import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class PasswordClientAuthenticator
implements ClientAuthenticator {
    private char[] password;
    private String username;
    private Authenticator authenticator = new Authenticator(){

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(PasswordClientAuthenticator.this.username, PasswordClientAuthenticator.this.password);
        }
    };

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public boolean isSSHKeyAvailable() {
        return false;
    }

    @Override
    public boolean processSSHSignatureCallbacks(String serverName, NameCallback nameCb, SSHSignatureCallback sshCb) {
        return false;
    }

    public PasswordClientAuthenticator(String password) {
        this(null, password);
    }

    public PasswordClientAuthenticator(String username, String password) {
        this.password = password.toCharArray();
        this.username = username;
    }

    @Override
    public char[] getNewPassword(Component parent, String serverInfo, String user) {
        return null;
    }

    @Override
    public boolean processPasswordCallbacks(String title, String serverType, String serverName, NameCallback nameCb, PasswordCallback passCb, ChoiceCallback choiceCb, AnonymousCallback anonymousCb, String loginError) {
        if (choiceCb != null) {
            choiceCb.setSelectedIndex(1);
        }
        if (nameCb != null && this.username != null) {
            nameCb.setName(this.username);
        }
        passCb.setPassword((char[])this.password.clone());
        return true;
    }

    @Override
    public boolean promptForReconnect(Component parent, String message) {
        return false;
    }

    public char[] getKeyStorePassword(String keystorePath, boolean passwordError) {
        if (passwordError) {
            return null;
        }
        return (char[])this.password.clone();
    }
}

