/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.Span;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public interface ULongSpan
extends Span<Long, ULongSpan> {
    public static final Domain DOMAIN = Domain.INSTANCE;
    public static final Empty EMPTY = Empty.INSTANCE;
    public static final Impl ALL = new Impl(DOMAIN.min(), DOMAIN.max());

    public static ULongSpan span(long min, long max) {
        return (ULongSpan)DOMAIN.closed(min, max);
    }

    public static ULongSpan extent(long min, long length) {
        return (ULongSpan)DOMAIN.closed(min, min + length - 1L);
    }

    public static ULongSpan extent(long min, int length) {
        return ULongSpan.extent(min, Integer.toUnsignedLong(length));
    }

    default public long length() {
        return (Long)this.max() - (Long)this.min() + 1L;
    }

    public static enum Domain implements Span.Domain<Long, ULongSpan>
    {
        INSTANCE;


        @Override
        public ULongSpan newSpan(Long min, Long max) {
            return new Impl(min, max);
        }

        @Override
        public ULongSpan all() {
            return ALL;
        }

        @Override
        public ULongSpan empty() {
            return EMPTY;
        }

        @Override
        public String toString(Long n) {
            return Long.toUnsignedString(n);
        }

        @Override
        public int compare(Long n1, Long n2) {
            return Long.compareUnsigned(n1, n2);
        }

        @Override
        public Long min() {
            return 0L;
        }

        @Override
        public Long max() {
            return -1L;
        }

        @Override
        public Long inc(Long n) {
            return n + 1L;
        }

        @Override
        public Long dec(Long n) {
            return n - 1L;
        }
    }

    public static class Empty
    implements ULongSpan,
    Span.Empty<Long, ULongSpan> {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        public String toString() {
            return this.doToString();
        }

        public Domain domain() {
            return DOMAIN;
        }

        @Override
        public long length() {
            return 0L;
        }
    }

    public static final class Impl
    extends Record
    implements ULongSpan {
        private final Long min;
        private final Long max;

        public Impl(Long min, Long max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public String toString() {
            return this.doToString();
        }

        @Override
        public Span.Domain<Long, ULongSpan> domain() {
            return DOMAIN;
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Impl.class, "min;max", "min", "max"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Impl.class, "min;max", "min", "max"}, this, o);
        }

        @Override
        public Long min() {
            return this.min;
        }

        @Override
        public Long max() {
            return this.max;
        }
    }

    public static class DefaultULongSpanSet
    extends Span.DefaultSpanSet<Long, ULongSpan>
    implements MutableULongSpanSet {
        public DefaultULongSpanSet() {
            super(DOMAIN);
        }
    }

    public static interface MutableULongSpanSet
    extends ULongSpanSet,
    Span.MutableSpanSet<Long, ULongSpan> {
    }

    public static interface ULongSpanSet
    extends Span.SpanSet<Long, ULongSpan> {
        public static ULongSpanSet of(ULongSpan ... spans) {
            DefaultULongSpanSet result = new DefaultULongSpanSet();
            for (ULongSpan s : spans) {
                result.add(s);
            }
            return result;
        }
    }

    public static class DefaultULongSpanMap<V>
    extends Span.DefaultSpanMap<Long, ULongSpan, V>
    implements MutableULongSpanMap<V> {
        public DefaultULongSpanMap() {
            super(DOMAIN);
        }
    }

    public static interface MutableULongSpanMap<V>
    extends ULongSpanMap<V>,
    Span.MutableSpanMap<Long, ULongSpan, V> {
    }

    public static interface ULongSpanMap<V>
    extends Span.SpanMap<Long, ULongSpan, V> {
    }
}

