/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.ActionContext;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.label.GDHtmlLabel;
import generic.theme.GThemeDefaults;
import ghidra.util.HTMLUtilities;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.apache.commons.lang3.StringUtils;

public class HorizontalRuleAction
extends DockingAction {
    private static final String PADDING = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static int idCount = 0;

    public HorizontalRuleAction(String owner, String topName, String bottomName) {
        super("HorizontalRuleAction: " + ++idCount, owner, false);
        this.setEnabled(false);
        this.markHelpUnnecessary();
        MenuData menuData = new MenuData(new String[]{""});
        String topHtml = HTMLUtilities.escapeHTML((String)topName);
        String bottomHtml = HTMLUtilities.escapeHTML((String)bottomName);
        menuData.setMenuItemNamePlain(String.format("<HTML><CENTER><FONT SIZE=2 COLOR=\"%s\">%s<BR>%s</FONT></CENTER>\n", GThemeDefaults.Colors.Palette.SILVER, topHtml, bottomHtml));
        this.setMenuBarData(menuData);
        this.setDescription(String.format("<HTML><CENTER><B>%s</B><HR><B>%s</B></CENTER>\n", PADDING + topHtml + PADDING, PADDING + bottomHtml + PADDING));
    }

    @Override
    public void actionPerformed(ActionContext context) {
    }

    @Override
    public JSeparator createMenuComponent(boolean isPopup) {
        String[] menuPath = this.getMenuBarData().getMenuPath();
        String name = menuPath[menuPath.length - 1];
        String description = this.getDescription();
        return new LabeledSeparator(name, description);
    }

    private static class LabeledSeparator
    extends JSeparator {
        private final int EMTPY_SEPARATOR_HEIGHT = 10;
        private final int TEXT_SEPARATOR_HEIGHT = 32;
        private JLabel renderer = new GDHtmlLabel();
        private int separatorHeight = 10;

        private LabeledSeparator(String name, String description) {
            this.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
            this.renderer.setText(name);
            DockingUtils.setTransparent(this.renderer);
            this.renderer.setHorizontalAlignment(0);
            this.renderer.setVisible(true);
            if (!StringUtils.isBlank((CharSequence)name)) {
                this.separatorHeight = 32;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            int pad = 10;
            int center = this.separatorHeight >> 1;
            int x = 0 + pad;
            int y = center;
            int w = d.width - pad;
            g.setColor(this.getForeground());
            g.drawLine(x, y, w, y);
            g.setColor(this.getBackground());
            g.drawLine(x, y + 1, w, y + 1);
            this.renderer.setSize(this.getSize());
            this.renderer.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, this.separatorHeight);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, this.separatorHeight);
        }
    }
}

