/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.pathmanager;

import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

class PathnameTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> pathList;
    private boolean isEditable;

    PathnameTableModel(String[] paths, boolean isEditable) {
        this.isEditable = isEditable;
        this.pathList = new ArrayList();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                this.pathList.add(paths[i]);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    public Class<String> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditable;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.pathList.remove(rowIndex);
        this.pathList.add(rowIndex, aValue.toString());
        super.fireTableCellUpdated(rowIndex, 0);
    }

    @Override
    public int getRowCount() {
        return this.pathList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.pathList.size()) {
            return null;
        }
        return this.pathList.get(rowIndex);
    }

    void setEditingEnabled(boolean isEditable) {
        this.isEditable = isEditable;
    }

    void remove(int[] selectedRows) {
        int i;
        String[] paths = new String[selectedRows.length];
        for (i = 0; i < selectedRows.length; ++i) {
            paths[i] = this.pathList.get(selectedRows[i]);
        }
        for (i = 0; i < paths.length; ++i) {
            this.pathList.remove(paths[i]);
        }
        this.fireTableDataChanged();
    }

    void moveUp(JTable table, int index) {
        if (index < 0 || index >= this.pathList.size()) {
            return;
        }
        String path = this.pathList.remove(index);
        int newIndex = 0;
        if (index == 0) {
            this.pathList.add(path);
            newIndex = this.pathList.size() - 1;
        } else {
            newIndex = index - 1;
            this.pathList.add(newIndex, path);
        }
        this.notifyDataChanged(table, newIndex);
    }

    void moveDown(JTable table, int index) {
        if (index < 0 || index >= this.pathList.size()) {
            return;
        }
        int size = this.pathList.size();
        int newIndex = 0;
        String path = this.pathList.remove(index);
        if (index == size - 1) {
            this.pathList.add(0, path);
        } else {
            newIndex = index + 1;
            this.pathList.add(index + 1, path);
        }
        this.notifyDataChanged(table, newIndex);
    }

    void addPaths(String[] paths, boolean addToTop) {
        for (int i = 0; i < paths.length; ++i) {
            if (this.pathList.contains(paths[i])) continue;
            if (addToTop) {
                this.pathList.add(i, paths[i]);
                continue;
            }
            this.pathList.add(paths[i]);
        }
        this.fireTableDataChanged();
    }

    void setPaths(String[] paths) {
        this.pathList.clear();
        this.addPaths(paths, false);
    }

    private void notifyDataChanged(JTable table, int newIndex) {
        this.fireTableDataChanged();
        table.setRowSelectionInterval(newIndex, newIndex);
        Rectangle rect = table.getCellRect(newIndex, 0, true);
        table.scrollRectToVisible(rect);
    }
}

