/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.shapes;

import docking.widgets.shapes.Location;
import ghidra.util.exception.AssertException;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.commons.lang3.StringUtils;

public abstract class PopupWindowPlacer {
    protected Location major;
    protected Location minorBegin;
    protected Location minorEnd;
    private PopupWindowPlacer next = null;

    public PopupWindowPlacer() {
    }

    public PopupWindowPlacer(Location major, Location minorBegin, Location minorEnd) {
        if (major == Location.CENTER) {
            throw new IllegalArgumentException("Cannot use " + major + " for major edge.");
        }
        if (!major.validMinor(minorBegin)) {
            throw new IllegalArgumentException("Invalid minor location for " + major + " edge: " + minorBegin);
        }
        if (!major.validMinor(minorEnd)) {
            throw new IllegalArgumentException("Invalid minor location for " + major + " edge: " + minorEnd);
        }
        this.major = major;
        this.minorBegin = minorBegin;
        this.minorEnd = minorEnd;
    }

    void setNext(PopupWindowPlacer next) {
        this.next = next;
    }

    public Rectangle getPlacement(Dimension toBePlaced, Rectangle innerBounds, Rectangle outerBounds) {
        Rectangle myPlacement = this.getMyPlacement(toBePlaced, innerBounds, outerBounds);
        if (myPlacement != null) {
            return myPlacement;
        }
        if (this.next != null) {
            return this.next.getPlacement(toBePlaced, innerBounds, outerBounds);
        }
        return null;
    }

    protected abstract Rectangle getMyPlacement(Dimension var1, Rectangle var2, Rectangle var3);

    protected PositionableRectangle getPlacement(PositionableRectangle result, PositionableDimension toBePlaced, PositionableRectangle context, PositionableRectangle outer) {
        Integer placementMinorCoordinate;
        int placementMajorCoordinate;
        if (this.major.isLesser()) {
            placementMajorCoordinate = this.getLesserLocation(context.getMajorCoordinate(), context.getMajorLength(), toBePlaced.getMajorLength());
            if (placementMajorCoordinate < (shiftedPlacement = this.getLesserBoundedLocation(placementMajorCoordinate, outer.getMajorCoordinate()))) {
                return null;
            }
        } else if (this.major.isGreater()) {
            placementMajorCoordinate = this.getGreaterLocation(context.getMajorCoordinate(), context.getMajorLength(), toBePlaced.getMajorLength());
            if (placementMajorCoordinate > (shiftedPlacement = this.getGreaterBoundedLocation(placementMajorCoordinate, toBePlaced.getMajorLength(), outer.getMajorCoordinate(), outer.getMajorLength()))) {
                return null;
            }
        } else {
            throw new AssertException("Should not get here.");
        }
        if ((placementMinorCoordinate = this.getPlacement(toBePlaced.getMinorLength(), context.getMinorCoordinate(), context.getMinorLength(), outer.getMinorCoordinate(), outer.getMinorLength())) == null) {
            return null;
        }
        result.set(placementMajorCoordinate, placementMinorCoordinate, toBePlaced);
        return result;
    }

    private Integer getPlacement(int placementLength, int contextLocation, int contextLength, int boundLocation, int boundLength) {
        int lesserLocation = this.getLesserLocation(contextLocation, contextLength, placementLength);
        int lesserBoundedLocation = this.getLesserBoundedLocation(lesserLocation, boundLocation);
        int greaterLocation = this.getGreaterLocation(contextLocation, contextLength, placementLength);
        int greaterBoundedLocation = this.getGreaterBoundedLocation(greaterLocation, placementLength, boundLocation, boundLength);
        if (greaterBoundedLocation < lesserBoundedLocation) {
            return null;
        }
        int centerLocation = this.getCenterLocation(contextLocation, contextLength, placementLength);
        if (greaterBoundedLocation < centerLocation) {
            return this.getSolutionWhenGreaterBoundedLessThanCenter(lesserLocation, lesserBoundedLocation, greaterBoundedLocation);
        }
        if (lesserBoundedLocation > centerLocation) {
            return this.getSolutionWhenLesserBoundedGreaterThanCenter(lesserBoundedLocation, greaterBoundedLocation, greaterLocation);
        }
        return this.getSolutionWhenCenterBounded(lesserLocation, lesserBoundedLocation, centerLocation, greaterBoundedLocation, greaterLocation);
    }

    private Integer getSolutionWhenGreaterBoundedLessThanCenter(int lesserLocation, int lesserBoundedLocation, int greaterBoundedLocation) {
        if (this.minorBegin.isLesser()) {
            if (this.minorEnd.isLesser() && lesserLocation != lesserBoundedLocation) {
                return null;
            }
            return lesserBoundedLocation;
        }
        if (this.minorEnd.isLesser()) {
            return greaterBoundedLocation;
        }
        return null;
    }

    private Integer getSolutionWhenLesserBoundedGreaterThanCenter(int lesserBoundedLocation, int greaterBoundedLocation, int greaterLocation) {
        if (this.minorBegin.isGreater()) {
            if (this.minorEnd.isGreater() && greaterLocation != greaterBoundedLocation) {
                return null;
            }
            return greaterBoundedLocation;
        }
        if (this.minorEnd.isGreater()) {
            return lesserBoundedLocation;
        }
        return null;
    }

    private Integer getSolutionWhenCenterBounded(int lesserLocation, int lesserBoundedLocation, int centerLocation, int greaterBoundedLocation, int greaterLocation) {
        if (this.minorBegin.isGreater()) {
            if (this.minorEnd.isGreater() && greaterLocation != greaterBoundedLocation) {
                return null;
            }
            return greaterBoundedLocation;
        }
        if (this.minorBegin.isLesser()) {
            if (this.minorEnd.isLesser() && lesserLocation != lesserBoundedLocation) {
                return null;
            }
            return lesserBoundedLocation;
        }
        return centerLocation;
    }

    protected int getGreaterBoundedLocation(int placementLocation, int placementLength, int boundLocation, int boundLength) {
        return Integer.min(placementLocation, boundLocation + boundLength - placementLength);
    }

    protected int getLesserBoundedLocation(int placementLocation, int boundLocation) {
        return Integer.max(placementLocation, boundLocation);
    }

    protected int getGreaterLocation(int contextLocation, int contextLength, int placementLength) {
        return contextLocation + contextLength;
    }

    protected int getLesserLocation(int contextLocation, int contextLength, int placementLength) {
        return contextLocation - placementLength;
    }

    protected int getCenterLocation(int contextLocation, int contextLength, int placementLength) {
        return contextLocation + (contextLength - placementLength) / 2;
    }

    private String debugDump(Rectangle placement) {
        return String.format("%s: %s(%s,%s)... placement %s", new Object[]{this.getClass().getSimpleName(), this.major, this.minorBegin, this.minorEnd, this.dumpRectangle(placement)});
    }

    private String dumpRectangle(Rectangle r) {
        if (r == null) {
            return "null";
        }
        return String.format("[x=%d,y=%d,width=%d,height=%d]", r.x, r.y, r.width, r.height);
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        String specificName = name.replace(PopupWindowPlacer.class.getSimpleName(), "");
        Object[] words = StringUtils.splitByCharacterTypeCamelCase((String)specificName);
        return StringUtils.join((Object[])words, (char)' ');
    }

    private static abstract class PositionableRectangle
    extends Rectangle {
        PositionableRectangle() {
        }

        public PositionableRectangle(Rectangle rectangle) {
            super(rectangle);
        }

        public void set(int majorCoordinate, int minorCoordinate, PositionableDimension dimension) {
            this.setMajorCoordinate(majorCoordinate);
            this.setMinorCoordinate(minorCoordinate);
            this.setSize(dimension);
        }

        abstract int getMajorCoordinate();

        abstract void setMajorCoordinate(int var1);

        abstract int getMinorCoordinate();

        abstract void setMinorCoordinate(int var1);

        abstract int getMajorLength();

        abstract void setMajorLength(int var1);

        abstract int getMinorLength();

        abstract void setMinorLength(int var1);
    }

    private static abstract class PositionableDimension
    extends Dimension {
        public PositionableDimension(Dimension dimension) {
            super(dimension);
        }

        abstract int getMajorLength();

        abstract void setMajorLength(int var1);

        abstract int getMinorLength();

        abstract void setMinorLength(int var1);
    }

    private static class VerticalMajorRectangle
    extends PositionableRectangle {
        VerticalMajorRectangle() {
        }

        public VerticalMajorRectangle(Rectangle rectangle) {
            super(rectangle);
        }

        @Override
        int getMajorCoordinate() {
            return this.y;
        }

        @Override
        void setMajorCoordinate(int coordinate) {
            this.y = coordinate;
        }

        @Override
        int getMinorCoordinate() {
            return this.x;
        }

        @Override
        void setMinorCoordinate(int coordinate) {
            this.x = coordinate;
        }

        @Override
        int getMajorLength() {
            return this.height;
        }

        @Override
        void setMajorLength(int length) {
            this.height = length;
        }

        @Override
        int getMinorLength() {
            return this.width;
        }

        @Override
        void setMinorLength(int length) {
            this.width = length;
        }
    }

    private static class HorizontalMajorRectangle
    extends PositionableRectangle {
        HorizontalMajorRectangle() {
        }

        public HorizontalMajorRectangle(Rectangle rectangle) {
            super(rectangle);
        }

        @Override
        int getMajorCoordinate() {
            return this.x;
        }

        @Override
        void setMajorCoordinate(int coordinate) {
            this.x = coordinate;
        }

        @Override
        int getMinorCoordinate() {
            return this.y;
        }

        @Override
        void setMinorCoordinate(int coordinate) {
            this.y = coordinate;
        }

        @Override
        int getMajorLength() {
            return this.width;
        }

        @Override
        void setMajorLength(int length) {
            this.width = length;
        }

        @Override
        int getMinorLength() {
            return this.height;
        }

        @Override
        void setMinorLength(int length) {
            this.height = length;
        }
    }

    private static class VerticalMajorDimension
    extends PositionableDimension {
        public VerticalMajorDimension(Dimension dimension) {
            super(dimension);
        }

        @Override
        int getMajorLength() {
            return this.height;
        }

        @Override
        void setMajorLength(int length) {
            this.height = length;
        }

        @Override
        int getMinorLength() {
            return this.width;
        }

        @Override
        void setMinorLength(int length) {
            this.width = length;
        }
    }

    private static class HorizontalMajorDimension
    extends PositionableDimension {
        public HorizontalMajorDimension(Dimension dimension) {
            super(dimension);
        }

        @Override
        int getMajorLength() {
            return this.width;
        }

        @Override
        void setMajorLength(int length) {
            this.width = length;
        }

        @Override
        int getMinorLength() {
            return this.height;
        }

        @Override
        void setMinorLength(int length) {
            this.height = length;
        }
    }

    static class ThrowsAssertExceptionPlacer
    extends PopupWindowPlacer {
        ThrowsAssertExceptionPlacer() {
        }

        @Override
        public Rectangle getMyPlacement(Dimension toBePlaced, Rectangle innerBounds, Rectangle outerBounds) {
            throw new AssertException("Unexpected popup placement error.");
        }
    }

    static class LeastOverlapCornerPopupWindowPlacer
    extends PopupWindowPlacer {
        @Override
        public Rectangle getMyPlacement(Dimension toBePlaced, Rectangle context, Rectangle outer) {
            Rectangle bestRectangle = null;
            int bestArea = Integer.MAX_VALUE;
            int top = this.getLesserLocation(context.y, context.height, toBePlaced.height);
            int bottom = this.getGreaterLocation(context.y, context.height, toBePlaced.height);
            int left = this.getLesserLocation(context.x, context.width, toBePlaced.width);
            int right = this.getGreaterLocation(context.x, context.width, toBePlaced.width);
            int topShifted = this.getLesserBoundedLocation(top, outer.y);
            int bottomShifted = this.getGreaterBoundedLocation(bottom, toBePlaced.height, outer.y, outer.height);
            int leftShifted = this.getLesserBoundedLocation(left, outer.x);
            int rightShifted = this.getGreaterBoundedLocation(right, toBePlaced.width, outer.x, outer.width);
            if (bottomShifted < topShifted || rightShifted < leftShifted) {
                return null;
            }
            Rectangle rectangle = new Rectangle(new Point(rightShifted, bottomShifted), toBePlaced);
            Rectangle intersection = rectangle.intersection(context);
            int area = intersection.width * intersection.height;
            if (area < bestArea) {
                bestArea = area;
                bestRectangle = rectangle;
            }
            rectangle = new Rectangle(new Point(leftShifted, bottomShifted), toBePlaced);
            intersection = rectangle.intersection(context);
            area = intersection.width * intersection.height;
            if (area < bestArea) {
                bestArea = area;
                bestRectangle = rectangle;
            }
            rectangle = new Rectangle(new Point(rightShifted, topShifted), toBePlaced);
            intersection = rectangle.intersection(context);
            area = intersection.width * intersection.height;
            if (area < bestArea) {
                bestArea = area;
                bestRectangle = rectangle;
            }
            rectangle = new Rectangle(new Point(leftShifted, topShifted), toBePlaced);
            intersection = rectangle.intersection(context);
            area = intersection.width * intersection.height;
            if (area < bestArea) {
                bestArea = area;
                bestRectangle = rectangle;
            }
            return bestRectangle;
        }
    }

    static class EdgePopupPlacer
    extends PopupWindowPlacer {
        public EdgePopupPlacer(Location major, Location minorBegin, Location minorEnd) {
            super(major, minorBegin, minorEnd);
        }

        @Override
        public Rectangle getMyPlacement(Dimension toBePlaced, Rectangle context, Rectangle outer) {
            if (this.major.isHorizontal()) {
                return this.getPlacement(new HorizontalMajorRectangle(), new HorizontalMajorDimension(toBePlaced), new HorizontalMajorRectangle(context), new HorizontalMajorRectangle(outer));
            }
            return this.getPlacement(new VerticalMajorRectangle(), new VerticalMajorDimension(toBePlaced), new VerticalMajorRectangle(context), new VerticalMajorRectangle(outer));
        }
    }
}

