/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.event;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugEventCallbacks;
import agent.dbgeng.dbgeng.DebugExceptionRecord64;
import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugProcessInfo;
import agent.dbgeng.dbgeng.DebugThreadInfo;
import agent.dbgeng.impl.dbgeng.breakpoint.DebugBreakpointInternal;
import agent.dbgeng.impl.dbgeng.client.DebugClientImpl5;
import agent.dbgeng.impl.dbgeng.client.DebugClientInternal;
import agent.dbgeng.jna.dbgeng.WinNTExtra;
import agent.dbgeng.jna.dbgeng.breakpoint.WrapIDebugBreakpoint;
import agent.dbgeng.jna.dbgeng.event.CallbackIDebugEventCallbacksWide;
import agent.dbgeng.jna.dbgeng.event.IDebugEventCallbacksWide;
import agent.dbgeng.jna.dbgeng.event.ListenerIDebugEventCallbacksWide;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.IUnknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.comm.util.BitmaskSet;
import ghidra.util.Msg;
import java.util.ArrayList;

public class WrapCallbackIDebugEventCallbacksWide
implements CallbackIDebugEventCallbacksWide {
    private static final WinNT.HRESULT ERROR_RESULT = new WinNT.HRESULT(-2147418113);
    private final DebugClientInternal client;
    private final DebugEventCallbacks cb;
    private ListenerIDebugEventCallbacksWide listener;

    public WrapCallbackIDebugEventCallbacksWide(DebugClientImpl5 client, DebugEventCallbacks cb) {
        this.client = client;
        this.cb = cb;
    }

    public void setListener(ListenerIDebugEventCallbacksWide listener) {
        this.listener = listener;
    }

    public Pointer getPointer() {
        return this.listener.getPointer();
    }

    public WinNT.HRESULT QueryInterface(Guid.REFIID refid, PointerByReference ppvObject) {
        if (null == ppvObject) {
            return new WinNT.HRESULT(-2147467261);
        }
        if (refid.getValue().equals((Object)IDebugEventCallbacksWide.IID_IDEBUG_EVENT_CALLBACKS_WIDE)) {
            ppvObject.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (refid.getValue().equals((Object)IUnknown.IID_IUNKNOWN)) {
            ppvObject.setValue(this.getPointer());
            return WinError.S_OK;
        }
        return new WinNT.HRESULT(-2147467262);
    }

    public int AddRef() {
        return 0;
    }

    public int Release() {
        return 0;
    }

    @Override
    public WinNT.HRESULT GetInterestMask(WinDef.ULONGByReference Mask) {
        try {
            BitmaskSet<DebugEventCallbacks.DebugEvent> interest = this.cb.getInterestMask();
            WinDef.ULONG ulInterest = new WinDef.ULONG(interest.getBitmask());
            Mask.setValue(ulInterest);
            return WinError.S_OK;
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT Breakpoint(WrapIDebugBreakpoint.ByReference Bp) {
        try {
            DebugBreakpointInternal bpt = DebugBreakpointInternal.tryPreferredInterfaces(this.client.getControlInternal(), (arg_0, arg_1) -> ((WrapIDebugBreakpoint.ByReference)Bp).QueryInterface(arg_0, arg_1));
            DebugClient.DebugStatus status = this.cb.breakpoint(bpt);
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT Exception(WinNTExtra.EXCEPTION_RECORD64.ByReference Exception2, WinDef.ULONG FirstChance) {
        try {
            int numParams = Exception2.NumberParameters.intValue();
            ArrayList<Long> information = new ArrayList<Long>(numParams);
            for (int i = 0; i < numParams; ++i) {
                information.add(Exception2.ExceptionInformation[i].longValue());
            }
            DebugExceptionRecord64 exc = new DebugExceptionRecord64(Exception2.ExceptionCode.intValue(), Exception2.ExceptionFlags.intValue(), Exception2.ExceptionRecord.longValue(), Exception2.ExceptionAddress.longValue(), information);
            boolean firstChance = FirstChance.intValue() != 0;
            DebugClient.DebugStatus status = this.cb.exception(exc, firstChance);
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT CreateThread(WinDef.ULONGLONG Handle, WinDef.ULONGLONG DataOffset, WinDef.ULONGLONG StartOffset) {
        try {
            DebugClient.DebugStatus status = this.cb.createThread(new DebugThreadInfo(Handle.longValue(), DataOffset.longValue(), StartOffset.longValue()));
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT ExitThread(WinDef.ULONG ExitCode) {
        try {
            DebugClient.DebugStatus status = this.cb.exitThread(ExitCode.intValue());
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT CreateProcess(WinDef.ULONGLONG ImageFileHandle, WinDef.ULONGLONG Handle, WinDef.ULONGLONG BaseOffset, WinDef.ULONG ModuleSize, WString ModuleName, WString ImageName, WinDef.ULONG CheckSum, WinDef.ULONG TimeDateStamp, WinDef.ULONGLONG InitialThreadHandle, WinDef.ULONGLONG ThreadDataOffset, WinDef.ULONGLONG StartOffset) {
        try {
            DebugClient.DebugStatus status = this.cb.createProcess(new DebugProcessInfo(Handle.longValue(), new DebugModuleInfo(ImageFileHandle.longValue(), BaseOffset.longValue(), ModuleSize.intValue(), ModuleName.toString(), ImageName.toString(), CheckSum.intValue(), TimeDateStamp.intValue()), new DebugThreadInfo(InitialThreadHandle.longValue(), ThreadDataOffset.longValue(), StartOffset.longValue())));
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT ExitProcess(WinDef.ULONG ExitCode) {
        try {
            DebugClient.DebugStatus status = this.cb.exitProcess(ExitCode.intValue());
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT LoadModule(WinDef.ULONGLONG ImageFileHandle, WinDef.ULONGLONG BaseOffset, WinDef.ULONG ModuleSize, WString ModuleName, WString ImageName, WinDef.ULONG CheckSum, WinDef.ULONG TimeDateStamp) {
        try {
            long imageFileHandle = ImageFileHandle == null ? -1L : ImageFileHandle.longValue();
            long baseOffset = BaseOffset == null ? -1L : BaseOffset.longValue();
            int moduleSize = ModuleSize == null ? -1 : ModuleSize.intValue();
            String moduleName = ModuleName == null ? "" : ModuleName.toString();
            String imageName = ImageName == null ? "" : ImageName.toString();
            int checkSum = CheckSum == null ? -1 : CheckSum.intValue();
            DebugClient.DebugStatus status = this.cb.loadModule(new DebugModuleInfo(imageFileHandle, baseOffset, moduleSize, moduleName, imageName, checkSum, TimeDateStamp.intValue()));
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT UnloadModule(WString ImageBaseName, WinDef.ULONGLONG BaseOffset) {
        try {
            DebugClient.DebugStatus status = this.cb.unloadModule(ImageBaseName.toString(), BaseOffset.longValue());
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT SystemError(WinDef.ULONG Error2, WinDef.ULONG Level2) {
        try {
            DebugClient.DebugStatus status = this.cb.systemError(Error2.intValue(), Level2.intValue());
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT SessionStatus(WinDef.ULONG Status) {
        try {
            DebugClient.SessionStatus ss = DebugClient.SessionStatus.values()[Status.intValue()];
            DebugClient.DebugStatus status = this.cb.sessionStatus(ss);
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT ChangeDebuggeeState(WinDef.ULONG Flags, WinDef.ULONGLONG Argument) {
        try {
            BitmaskSet flags = new BitmaskSet(DebugClient.ChangeDebuggeeState.class, (long)Flags.intValue());
            DebugClient.DebugStatus status = this.cb.changeDebuggeeState((BitmaskSet<DebugClient.ChangeDebuggeeState>)flags, Argument.longValue());
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT ChangeEngineState(WinDef.ULONG Flags, WinDef.ULONGLONG Argument) {
        try {
            BitmaskSet flags = new BitmaskSet(DebugClient.ChangeEngineState.class, (long)Flags.intValue());
            DebugClient.DebugStatus status = this.cb.changeEngineState((BitmaskSet<DebugClient.ChangeEngineState>)flags, Argument.longValue());
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }

    @Override
    public WinNT.HRESULT ChangeSymbolState(WinDef.ULONG Flags, WinDef.ULONGLONG Argument) {
        try {
            BitmaskSet flags = new BitmaskSet(DebugClient.ChangeSymbolState.class, (long)Flags.intValue());
            DebugClient.DebugStatus status = this.cb.changeSymbolState((BitmaskSet<DebugClient.ChangeSymbolState>)flags, Argument.longValue());
            return new WinNT.HRESULT(status.ordinal());
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Error during callback", (Throwable)e);
            return ERROR_RESULT;
        }
    }
}

