/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.plugin;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import functioncalls.graph.FunctionCallGraph;
import functioncalls.plugin.EmptyFcgData;
import functioncalls.plugin.FcgData;
import functioncalls.plugin.ValidFcgData;
import ghidra.program.model.listing.Function;

public class FcgDataFactory {
    private LoadingCache<Function, FcgData> cache;

    FcgDataFactory(RemovalListener<Function, FcgData> listener) {
        this.cache = CacheBuilder.newBuilder().maximumSize(5L).removalListener(listener).build((CacheLoader)new CacheLoader<Function, FcgData>(){

            public FcgData load(Function f) throws Exception {
                return new ValidFcgData(f, new FunctionCallGraph());
            }
        });
    }

    FcgData create(Function f) {
        if (f == null) {
            return new EmptyFcgData();
        }
        FcgData data = (FcgData)this.cache.getUnchecked((Object)f);
        return data;
    }

    void remove(Function f) {
        this.cache.invalidate((Object)f);
    }

    void dispose() {
        this.cache.invalidateAll();
    }
}

