/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.app.services.BlockModelService;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.SubroutineBlockModel;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.GroupPath;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ModuleAlgorithmCmd
extends BackgroundCommand {
    private static final String NEW_MODULE_SUFFIX = " [Subroutine Tree]";
    private static final String PROGRAM_CHANGED_MESSAGE = "Modularization did not run: Program Tree has changed since the algorithm was scheduled.";
    private GroupPath groupPath;
    private String treeName;
    private BlockModelService blockModelService;
    private String partitioningModelName;
    private Set<ProgramModule> moduleSet = new HashSet<ProgramModule>();
    private PluginTool tool;

    public ModuleAlgorithmCmd(GroupPath path, String treeName, BlockModelService blockModelService, String partitioningModelName) {
        super("Modularize By Subroutine", false, true, true);
        this.groupPath = path;
        this.treeName = treeName;
        this.blockModelService = blockModelService;
        this.partitioningModelName = partitioningModelName;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        ProgramModule root = program.getListing().getRootModule(this.treeName);
        try {
            boolean status = this.applyModel(program, root, monitor);
            if (status && this.getStatusMsg() != null && this.tool != null) {
                this.tool.setStatusInfo(this.getStatusMsg());
            }
            return status;
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            this.setStatusMsg("Modularize failed: " + msg);
            return false;
        }
    }

    public void setPluginTool(PluginTool tool) {
        this.tool = tool;
    }

    private boolean applyModel(Program program, ProgramModule root, TaskMonitor monitor) throws NotFoundException, NotEmptyException, DuplicateNameException {
        Group group = this.groupPath.getGroup(program, this.treeName);
        if (group == null) {
            this.setStatusMsg(PROGRAM_CHANGED_MESSAGE);
            return true;
        }
        SubroutineBlockModel partitioningModel = null;
        partitioningModel = this.partitioningModelName == null ? (SubroutineBlockModel)this.blockModelService.getActiveSubroutineModel(program) : (SubroutineBlockModel)this.blockModelService.getNewModelByName(this.partitioningModelName, program);
        SubroutineBlockModel baseModel = partitioningModel.getBaseSubroutineModel();
        ProgramModule parent = null;
        GroupPath parentPath = this.groupPath.getParentPath();
        if (parentPath != null && (parent = (ProgramModule)parentPath.getGroup(program, this.treeName)) == null && parentPath.getPathCount() > 1) {
            this.setStatusMsg(PROGRAM_CHANGED_MESSAGE);
            return true;
        }
        int index = 0;
        if (parent != null) {
            index = parent.getIndex(group.getName());
        }
        try {
            CodeBlockIterator cbi = null;
            ProgramModule module = null;
            if (group instanceof ProgramModule) {
                if (group.equals(root)) {
                    cbi = baseModel.getCodeBlocks(monitor);
                    module = program.getListing().getRootModule(this.treeName);
                } else {
                    module = (ProgramModule)group;
                    String name = module.getName();
                    if (name.indexOf(NEW_MODULE_SUFFIX) < 0) {
                        module.setName(module.getName() + NEW_MODULE_SUFFIX);
                    }
                    cbi = baseModel.getCodeBlocksContaining(module.getAddressSet(), monitor);
                }
            } else {
                if (parent == null) {
                    parent = program.getListing().getRootModule(this.treeName);
                }
                ProgramFragment fragment = (ProgramFragment)group;
                cbi = baseModel.getCodeBlocksContaining((AddressSetView)fragment, monitor);
                module = this.createModule(parent, fragment.getName() + NEW_MODULE_SUFFIX);
                String newName = module.getName();
                parent.moveChild(newName, index);
            }
            while (cbi.hasNext()) {
                monitor.checkCancelled();
                CodeBlock cb = cbi.next();
                monitor.setMessage("Processing code block @ " + cb.getMinAddress().toString(true));
                ArrayList<CodeBlock> list = new ArrayList<CodeBlock>();
                CodeBlockIterator cbi2 = partitioningModel.getCodeBlocksContaining((AddressSetView)cb, monitor);
                while (cbi2.hasNext() && !monitor.isCancelled()) {
                    CodeBlock cb2 = cbi2.next();
                    list.add(cb2);
                }
                ProgramModule parentModule = list.size() > 1 ? this.createModule(module, cb) : module;
                for (CodeBlock codeBlock : list) {
                    monitor.checkCancelled();
                    ProgramFragment fragment = this.createFragment(parentModule, codeBlock);
                    this.moveCodeUnits(fragment, codeBlock, monitor);
                }
            }
        }
        catch (CancelledException e) {
            this.setStatusMsg("Modularize was cancelled");
            return false;
        }
        this.cleanTree(root);
        return true;
    }

    private ProgramFragment createFragment(ProgramModule root, CodeBlock block) {
        boolean done = false;
        int index = 0;
        String baseName = block.getName();
        Object name = baseName;
        while (!done) {
            try {
                return root.createFragment((String)name);
            }
            catch (DuplicateNameException e) {
                name = baseName + "(" + ++index + ")";
            }
        }
        return null;
    }

    private ProgramModule createModule(ProgramModule root, CodeBlock block) {
        boolean done = false;
        int index = 0;
        String baseName = block.getName();
        Object name = baseName;
        while (!done) {
            try {
                return root.createModule((String)name);
            }
            catch (DuplicateNameException e) {
                name = baseName + "(" + ++index + ")";
            }
        }
        return null;
    }

    private void moveCodeUnits(ProgramFragment fragment, CodeBlock block, TaskMonitor monitor) throws NotFoundException {
        AddressRangeIterator iter = block.getAddressRanges();
        while (iter.hasNext() && !monitor.isCancelled()) {
            AddressRange range = (AddressRange)iter.next();
            fragment.move(range.getMinAddress(), range.getMaxAddress());
        }
    }

    private void cleanTree(ProgramModule module) throws NotEmptyException {
        Group[] children;
        if (module == null || this.moduleSet.contains(module)) {
            return;
        }
        this.moduleSet.add(module);
        if (module.getNumChildren() == 0) {
            return;
        }
        for (Group child : children = module.getChildren()) {
            if (child instanceof ProgramModule) {
                ProgramModule childModule = (ProgramModule)child;
                this.cleanTree(childModule);
                if (childModule.getNumChildren() != 0) continue;
                module.removeChild(childModule.getName());
                continue;
            }
            ProgramFragment fragment = (ProgramFragment)child;
            if (!fragment.isEmpty()) continue;
            module.removeChild(fragment.getName());
        }
        if (module.getParents().length != 0) {
            try {
                String numKidsPrefix = "   [";
                String currentName = module.getName();
                int prefix = currentName.indexOf(numKidsPrefix);
                String baseName = prefix < 0 ? currentName : currentName.substring(0, prefix);
                module.setName(baseName + numKidsPrefix + module.getNumChildren() + "]");
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
    }

    private ProgramModule createModule(ProgramModule module, String newName) {
        boolean done = false;
        int index = 0;
        String baseName = new String(newName);
        Object name = baseName;
        while (!done) {
            try {
                return module.createModule((String)name);
            }
            catch (DuplicateNameException e) {
                name = baseName + "(" + ++index + ")";
            }
        }
        return null;
    }
}

