/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.widgets.label.GLabel;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableTextCellEditor;
import docking.widgets.table.SelectionManager;
import docking.widgets.textfield.GValidatedTextField;
import generic.theme.GIcon;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.memory.AddBlockDialog;
import ghidra.app.plugin.core.memory.AddBlockModel;
import ghidra.app.plugin.core.memory.ExpandBlockDialog;
import ghidra.app.plugin.core.memory.ExpandBlockDownModel;
import ghidra.app.plugin.core.memory.ExpandBlockModel;
import ghidra.app.plugin.core.memory.ExpandBlockUpModel;
import ghidra.app.plugin.core.memory.ImageBaseDialog;
import ghidra.app.plugin.core.memory.MemoryMapManager;
import ghidra.app.plugin.core.memory.MemoryMapModel;
import ghidra.app.plugin.core.memory.MemoryMapPlugin;
import ghidra.app.plugin.core.memory.MoveBlockDialog;
import ghidra.app.plugin.core.memory.MoveBlockModel;
import ghidra.app.plugin.core.memory.SplitBlockDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class MemoryMapProvider
extends ComponentProviderAdapter {
    private static final int MAX_SIZE = 256;
    private JPanel mainPanel;
    private GTable memTable;
    private JScrollPane memPane;
    private MemoryMapModel mapModel;
    private DockingAction addAction;
    private DockingAction moveAction;
    private DockingAction splitAction;
    private DockingAction expandUpAction;
    private DockingAction expandDownAction;
    private DockingAction mergeAction;
    private DockingAction deleteAction;
    private DockingAction setBaseAction;
    private MemoryMapPlugin plugin = null;
    private Program program;
    private MemoryMapManager memManager;

    MemoryMapProvider(MemoryMapPlugin plugin) {
        super(plugin.getTool(), "Memory Map", plugin.getName(), ProgramActionContext.class);
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), this.getName()));
        this.memManager = plugin.getMemoryMapManager();
        this.setIcon((Icon)new GIcon("icon.plugin.memorymap.provider"));
        this.addToToolbar();
        this.mainPanel = this.buildMainPanel();
        this.addToTool();
        this.addLocalActions();
    }

    public void componentShown() {
        this.updateMap();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.program == null) {
            return null;
        }
        return new ProgramActionContext((ComponentProvider)this, this.program);
    }

    void setStatusText(String msg) {
        this.tool.setStatusInfo(msg);
    }

    void dispose() {
        this.removeFromTool();
        this.memTable.dispose();
        this.plugin = null;
        this.program = null;
        this.tool = null;
    }

    void setProgram(Program program) {
        this.program = program;
        this.updateMap(program);
        this.arrangeTable();
    }

    MemoryMapManager getMemoryMapManager() {
        return this.memManager;
    }

    private JPanel buildMainPanel() {
        JPanel memPanel = new JPanel(new BorderLayout());
        this.mapModel = new MemoryMapModel(this, null);
        this.memTable = new MemoryMapTable((TableModel)((Object)this.mapModel));
        this.memTable.setAutoCreateColumnsFromModel(false);
        GTableCellRenderer monoRenderer = new GTableCellRenderer();
        monoRenderer.setFont(monoRenderer.getFixedWidthFont());
        TableColumn column = this.memTable.getColumn((Object)"Start");
        column.setCellRenderer((TableCellRenderer)monoRenderer);
        column = this.memTable.getColumn((Object)"End");
        column.setCellRenderer((TableCellRenderer)monoRenderer);
        column = this.memTable.getColumn((Object)"Length");
        column.setCellRenderer((TableCellRenderer)monoRenderer);
        column = this.memTable.getColumn((Object)"R");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        column = this.memTable.getColumn((Object)"W");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        column = this.memTable.getColumn((Object)"X");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        column = this.memTable.getColumn((Object)"Volatile");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        column = this.memTable.getColumn((Object)"Overlay");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        column = this.memTable.getColumn((Object)"Initialized");
        column.setCellRenderer((TableCellRenderer)new GBooleanCellRenderer());
        this.memTable.setDefaultEditor(String.class, (TableCellEditor)new GTableTextCellEditor((JTextField)new GValidatedTextField.MaxLengthField(256)));
        this.memPane = new JScrollPane((Component)this.memTable);
        this.memTable.setPreferredScrollableViewportSize(new Dimension(700, 105));
        this.memTable.addMouseListener((MouseListener)new MouseHandler());
        this.memTable.addKeyListener((KeyListener)new KeyHandler());
        this.memTable.setSelectionMode(2);
        ListSelectionModel lsm = this.memTable.getSelectionModel();
        lsm.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel model = (ListSelectionModel)e.getSource();
            this.enableOptions(model);
        });
        memPanel.add((Component)new GLabel("Memory Blocks", 0), "North");
        memPanel.add((Component)this.memPane, "Center");
        return memPanel;
    }

    private void addLocalActions() {
        GIcon addImage = new GIcon("icon.plugin.memorymap.add");
        this.addAction = new MemoryMapAction("Add Block", (Icon)addImage){

            public void actionPerformed(ActionContext context) {
                if (this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.showAddBlockDialog();
                }
            }
        };
        this.addAction.setEnabled(false);
        this.addAction.setDescription("Add a new block to memory");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.addAction);
        GIcon moveImage = new GIcon("icon.plugin.memorymap.move");
        this.moveAction = new MemoryMapAction("Move Block", (Icon)moveImage){

            public void actionPerformed(ActionContext context) {
                if (this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.moveBlock();
                }
            }
        };
        this.moveAction.setEnabled(false);
        this.moveAction.setDescription("Move a block to another address");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.moveAction);
        GIcon splitImage = new GIcon("icon.plugin.memorymap.split");
        this.splitAction = new MemoryMapAction("Split Block", (Icon)splitImage){

            public void actionPerformed(ActionContext context) {
                if (this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.splitBlock();
                }
            }
        };
        this.splitAction.setEnabled(false);
        this.splitAction.setDescription("Split a block");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.splitAction);
        GIcon expandUpImage = new GIcon("icon.plugin.memorymap.expand.up");
        this.expandUpAction = new MemoryMapAction("Expand Block Up", (Icon)expandUpImage){

            public void actionPerformed(ActionContext context) {
                if (this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.expandBlock(0);
                }
            }
        };
        this.expandUpAction.setEnabled(false);
        this.expandUpAction.setDescription("Expand block by setting new start address");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.expandUpAction);
        GIcon expandDownImage = new GIcon("icon.plugin.memorymap.expand.down");
        this.expandDownAction = new MemoryMapAction("Expand Block Down", (Icon)expandDownImage){

            public void actionPerformed(ActionContext context) {
                if (this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.expandBlock(1);
                }
            }
        };
        this.expandDownAction.setEnabled(false);
        this.expandDownAction.setDescription("Expand block by setting new end address");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.expandDownAction);
        GIcon mergeImage = new GIcon("icon.plugin.memorymap.merge");
        this.mergeAction = new MemoryMapAction("Merge Blocks", (Icon)mergeImage){

            public void actionPerformed(ActionContext context) {
                if (this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.mergeBlocks();
                }
            }
        };
        this.mergeAction.setEnabled(false);
        this.mergeAction.setDescription("Merge blocks into a single block");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.mergeAction);
        GIcon deleteImage = new GIcon("icon.plugin.memorymap.delete");
        this.deleteAction = new MemoryMapAction("Delete Block", (Icon)deleteImage){

            public void actionPerformed(ActionContext context) {
                if (this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.deleteBlocks();
                }
            }
        };
        this.deleteAction.setEnabled(false);
        this.deleteAction.setDescription("Delete a block");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.deleteAction);
        GIcon setBaseIcon = new GIcon("icon.plugin.memorymap.image.base");
        this.setBaseAction = new MemoryMapAction("Set Image Base", (Icon)setBaseIcon){

            public void actionPerformed(ActionContext context) {
                if (this.checkExclusiveAccess()) {
                    MemoryMapProvider.this.setBase();
                }
            }
        };
        this.setBaseAction.setEnabled(false);
        this.setBaseAction.setDescription("Set Image Base");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.setBaseAction);
    }

    private void setBase() {
        ImageBaseDialog dialog = new ImageBaseDialog(this.tool, this.program, this.program.getImageBase());
        this.tool.showDialog((DialogComponentProvider)dialog, (ComponentProvider)this);
        dialog.dispose();
    }

    private void enableOptions(ListSelectionModel lsm) {
        int numSelected = 0;
        numSelected = lsm == null || lsm.isSelectionEmpty() ? 0 : (lsm.getMinSelectionIndex() == lsm.getMaxSelectionIndex() ? 1 : 2);
        this.addAction.setEnabled(true);
        this.moveAction.setEnabled(numSelected == 1);
        this.enableSplitAction(numSelected);
        this.enableExpandActions(numSelected);
        this.mergeAction.setEnabled(numSelected > 1);
        this.deleteAction.setEnabled(numSelected >= 1);
    }

    private void enableSplitAction(int numSelected) {
        if (numSelected != 1) {
            this.splitAction.setEnabled(false);
        } else {
            MemoryBlock block = this.getSelectedBlock();
            this.splitAction.setEnabled(block.getType() == MemoryBlockType.DEFAULT);
        }
    }

    private void enableExpandActions(int numSelected) {
        if (numSelected != 1) {
            this.expandUpAction.setEnabled(false);
            this.expandDownAction.setEnabled(false);
        } else {
            MemoryBlock block = this.getSelectedBlock();
            if (block.getType() != MemoryBlockType.DEFAULT) {
                this.expandDownAction.setEnabled(false);
                this.expandUpAction.setEnabled(false);
                return;
            }
            if (block.getStart().getOffset() == 0L) {
                this.expandUpAction.setEnabled(false);
            } else {
                this.expandUpAction.setEnabled(true);
            }
            Address endAddr = block.getEnd();
            if (endAddr.equals((Object)endAddr.getAddressSpace().getMaxAddress())) {
                this.expandDownAction.setEnabled(false);
            } else {
                this.expandDownAction.setEnabled(true);
            }
        }
    }

    JTable getTable() {
        return this.memTable;
    }

    void updateMap() {
        if (this.isVisible()) {
            this.mapModel.update();
            this.arrangeTable();
            this.updateTitle();
        }
    }

    void updateData() {
        if (this.isVisible()) {
            this.updateTitle();
            this.memTable.repaint();
        }
    }

    private void updateTitle() {
        if (this.program != null) {
            this.setSubTitle("Image Base: " + this.program.getImageBase().toString());
        }
    }

    private void updateMap(Program updateProgram) {
        this.enableOptions(null);
        if (updateProgram == null) {
            this.addAction.setEnabled(false);
            this.setBaseAction.setEnabled(false);
        } else {
            this.setBaseAction.setEnabled(true);
        }
        this.mapModel = new MemoryMapModel(this, updateProgram);
        this.memTable.setModel((TableModel)((Object)this.mapModel));
        this.updateTitle();
    }

    private void arrangeTable() {
        TableColumn column = this.memTable.getColumn((Object)"R");
        if (column != null) {
            column.setMaxWidth(25);
            column.setMinWidth(25);
            column.setResizable(false);
        }
        if ((column = this.memTable.getColumn((Object)"W")) != null) {
            column.setMaxWidth(25);
            column.setMinWidth(25);
            column.setResizable(false);
        }
        if ((column = this.memTable.getColumn((Object)"X")) != null) {
            column.setMaxWidth(25);
            column.setMinWidth(25);
            column.setResizable(false);
        }
        if ((column = this.memTable.getColumn((Object)"Volatile")) != null) {
            column.setMaxWidth(65);
            column.setMinWidth(65);
            column.setResizable(false);
        }
        if ((column = this.memTable.getColumn((Object)"Overlay")) != null) {
            column.setMaxWidth(65);
            column.setMinWidth(65);
            column.setResizable(false);
        }
        if ((column = this.memTable.getColumn((Object)"Type")) != null) {
            column.setMinWidth(60);
        }
        if ((column = this.memTable.getColumn((Object)"Initialized")) != null) {
            column.setMaxWidth(80);
            column.setMinWidth(80);
            column.setResizable(false);
        }
    }

    private void selectAddress() {
        int row = this.memTable.getSelectedRow();
        int viewColumn = this.memTable.getSelectedColumn();
        int col = this.memTable.convertColumnIndexToModel(viewColumn);
        MemoryBlock block = this.mapModel.getBlockAt(row);
        if (block != null && (col == 1 || col == 2)) {
            Address addr = col == 1 ? block.getStart() : block.getEnd();
            this.plugin.blockSelected(block, addr);
            this.memTable.setRowSelectionInterval(row, row);
        }
    }

    private MemoryBlock getSelectedBlock() {
        int row = this.memTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.mapModel.getBlockAt(row);
    }

    private void deleteBlocks() {
        int[] delRows;
        if (!this.program.canLock()) {
            this.setStatusText("Program is busy, try again later");
            return;
        }
        ArrayList<MemoryBlock> delBlocks = new ArrayList<MemoryBlock>();
        for (int element : delRows = this.memTable.getSelectedRows()) {
            MemoryBlock block = this.mapModel.getBlockAt(element);
            delBlocks.add(block);
        }
        this.memTable.clearSelection();
        this.deleteBlock(delBlocks);
    }

    private void deleteBlock(ArrayList<MemoryBlock> blocks) {
        this.memManager.deleteBlocks(blocks);
    }

    private void expandBlock(int dialogType) {
        MemoryBlock block = this.getSelectedBlock();
        if (block == null) {
            return;
        }
        if (block.isOverlay()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Expand Overlay Block Not Allowed", (Object)"Overlay blocks cannot be expanded.");
        } else {
            this.showExpandBlockDialog(dialogType, block);
        }
    }

    private void moveBlock() {
        if (!this.program.canLock()) {
            this.setStatusText("Program is busy, try again later");
            return;
        }
        MemoryBlock block = this.getSelectedBlock();
        if (block == null) {
            return;
        }
        if (block.isOverlay()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Move Overlay Block Not Allowed", (Object)"Overlay blocks cannot be moved.");
        } else {
            this.showMoveBlockDialog(block);
        }
    }

    private void splitBlock() {
        MemoryBlock block = this.getSelectedBlock();
        if (block == null) {
            return;
        }
        if (block.isOverlay()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Split Overlay Block Not Allowed", (Object)"Overlay blocks cannot be split.");
        } else {
            SplitBlockDialog d = new SplitBlockDialog(this.plugin, block, this.program.getAddressFactory());
            this.tool.showDialog((DialogComponentProvider)d, (ComponentProvider)this);
        }
    }

    private void showExpandBlockDialog(int dialogType, MemoryBlock block) {
        ExpandBlockModel model = dialogType == 0 ? new ExpandBlockUpModel(this.tool, this.program) : new ExpandBlockDownModel(this.tool, this.program);
        ExpandBlockDialog dialog = new ExpandBlockDialog(this.tool, model, block, this.program.getAddressFactory(), dialogType);
        model.initialize(block);
        dialog.dispose();
    }

    private void showMoveBlockDialog(MemoryBlock block) {
        MoveBlockModel model = new MoveBlockModel(this.program);
        new MoveBlockDialog(model, this.tool);
        model.initialize(block);
    }

    private void mergeBlocks() {
        int[] rows;
        ArrayList<MemoryBlock> blocks = new ArrayList<MemoryBlock>();
        for (int element : rows = this.memTable.getSelectedRows()) {
            MemoryBlock block = this.mapModel.getBlockAt(element);
            blocks.add(block);
        }
        this.memTable.clearSelection();
        this.memManager.mergeBlocks(blocks);
    }

    void setCursor(Cursor cursor) {
        this.tool.getToolFrame().setCursor(cursor);
    }

    void showAddBlockDialog() {
        AddBlockModel model = new AddBlockModel(this.tool, this.program);
        AddBlockDialog d = new AddBlockDialog(model);
        d.showDialog(this.tool);
    }

    public PluginTool getTool() {
        return this.plugin.getTool();
    }

    private class MemoryMapTable
    extends GhidraTable {
        MemoryMapTable(TableModel model) {
            super(model);
            this.setAutoEditEnabled(true);
            this.setActionsEnabled(true);
            this.setVisibleRowCount(10);
        }

        protected <T> SelectionManager createSelectionManager() {
            return null;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MemoryMapProvider.this.setStatusText("");
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MemoryMapProvider.this.setStatusText("");
            if (!e.isPopupTrigger() && (e.getModifiersEx() & 0xC0) == 0) {
                MemoryMapProvider.this.selectAddress();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MemoryMapProvider.this.setStatusText("");
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                MemoryMapProvider.this.selectAddress();
                e.consume();
            }
        }
    }

    private abstract class MemoryMapAction
    extends DockingAction {
        MemoryMapAction(String name, Icon icon) {
            super(name, MemoryMapProvider.this.plugin.getName());
            this.setToolBarData(new ToolBarData(icon, null));
        }

        public boolean checkExclusiveAccess() {
            if (MemoryMapProvider.this.program.hasExclusiveAccess()) {
                return true;
            }
            String msg = "Close the file and undo your checkout,\nthen do a checkout with the exclusive lock.";
            DomainFile df = MemoryMapProvider.this.program.getDomainFile();
            if (df.modifiedSinceCheckout() || df.isChanged()) {
                msg = "Check in this file, then do a checkout with the\nexclusive lock.";
            }
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)MemoryMapProvider.this.getComponent(), (String)"Exclusive Checkout Required", (Object)("An exclusive checkout is required in order to\nmanipulate memory blocks or change the image base.\n" + msg));
            return false;
        }
    }
}

