/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import ghidra.app.events.CloseProgramPluginEvent;
import ghidra.app.events.OpenProgramPluginEvent;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramPostActivatedPluginEvent;
import ghidra.app.events.ProgramVisibilityChangePluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.app.plugin.core.progmgr.TransactionMonitor;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.util.task.OpenProgramTask;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.LinkedDomainFile;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.TransientToolState;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.net.URL;
import java.rmi.NoSuchObjectException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jdom.Element;

class MultiProgramManager
implements DomainObjectListener,
TransactionListener {
    private ProgramManagerPlugin plugin;
    private PluginTool tool;
    private ProgramInfo currentInfo;
    private TransactionMonitor txMonitor;
    private MyFolderListener folderListener;
    private Runnable programChangedRunnable;
    private boolean hasUnsavedPrograms;
    private String pluginName;
    private List<ProgramInfo> openPrograms = new CopyOnWriteArrayList<ProgramInfo>();
    private ConcurrentHashMap<Program, ProgramInfo> programMap = new ConcurrentHashMap();

    MultiProgramManager(ProgramManagerPlugin programManagerPlugin) {
        this.plugin = programManagerPlugin;
        this.tool = programManagerPlugin.getTool();
        this.pluginName = this.plugin.getName();
        this.txMonitor = new TransactionMonitor();
        this.txMonitor.setName("Transaction Open (Program being modified)");
        this.tool.addStatusComponent((JComponent)this.txMonitor, true, true);
        this.folderListener = new MyFolderListener();
        this.tool.getProject().getProjectData().addDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        this.programChangedRunnable = () -> {
            if (this.tool == null) {
                return;
            }
            this.hasUnsavedPrograms = this.checkForUnsavedPrograms();
            this.plugin.contextChanged();
        };
    }

    void addProgram(Program p, DomainFile domainFile, int state) {
        this.addProgram(new ProgramInfo(p, domainFile, state != 0), state);
    }

    void addProgram(Program p, URL ghidraUrl, int state) {
        this.addProgram(new ProgramInfo(p, ghidraUrl, state != 0), state);
    }

    private void addProgram(ProgramInfo programInfo, int state) {
        Program p = programInfo.program;
        ProgramInfo oldInfo = this.getInfo(p);
        if (oldInfo == null) {
            oldInfo = programInfo;
            p.addConsumer((Object)this.tool);
            this.openPrograms.add(oldInfo);
            this.openPrograms.sort(Comparator.naturalOrder());
            this.programMap.put(p, oldInfo);
            this.fireOpenEvents(p);
            p.addListener((DomainObjectListener)this);
            p.addTransactionListener((TransactionListener)this);
        } else if (!oldInfo.visible && state != 0) {
            oldInfo.setVisible(true);
        }
        if (state == 1) {
            this.saveLocation();
            this.setCurrentProgram(p);
        }
    }

    void dispose() {
        this.tool.getProject().getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        this.fireActivatedEvent(null);
        for (Program p : this.programMap.keySet()) {
            p.removeListener((DomainObjectListener)this);
            p.removeTransactionListener((TransactionListener)this);
            this.fireCloseEvents(p);
            p.release((Object)this.tool);
        }
        this.programMap.clear();
        this.openPrograms.clear();
        this.tool.setSubTitle("");
        this.tool.removeStatusComponent((JComponent)this.txMonitor);
        this.tool = null;
        this.plugin = null;
    }

    void removeProgram(Program p) {
        ProgramInfo info = this.getInfo(p);
        if (info == null) {
            return;
        }
        if (info.owner != null) {
            info.setVisible(false);
            if (info == this.currentInfo) {
                ProgramInfo newCurrent = this.findNextCurrent();
                this.setCurrentProgram(newCurrent);
            }
        } else {
            p.removeTransactionListener((TransactionListener)this);
            this.programMap.remove(p);
            p.removeListener((DomainObjectListener)this);
            this.openPrograms.remove(info);
            if (info == this.currentInfo) {
                ProgramInfo newCurrent = this.findNextCurrent();
                this.setCurrentProgram(newCurrent);
            }
            this.fireCloseEvents(p);
            p.release((Object)this.tool);
            if (this.openPrograms.isEmpty()) {
                this.plugin.getTool().clearLastEvents();
            }
        }
    }

    private ProgramInfo findNextCurrent() {
        for (ProgramInfo pi : this.openPrograms) {
            if (!pi.visible) continue;
            return pi;
        }
        return null;
    }

    Program[] getOtherPrograms() {
        Program currentProgram = this.getCurrentProgram();
        List<Program> list = this.openPrograms.stream().map(info -> info.program).filter(program -> program != currentProgram).collect(Collectors.toList());
        return list.toArray(new Program[list.size()]);
    }

    Program[] getAllPrograms() {
        List list = this.openPrograms.stream().map(info -> info.program).collect(Collectors.toList());
        return (Program[])list.toArray(Program[]::new);
    }

    Program getCurrentProgram() {
        if (this.currentInfo != null) {
            return this.currentInfo.program;
        }
        return null;
    }

    void setCurrentProgram(Program p) {
        if (this.currentInfo != null && this.currentInfo.program.equals(p)) {
            return;
        }
        if (p == null) {
            return;
        }
        ProgramInfo info = this.getInfo(p);
        if (info != null) {
            this.setCurrentProgram(info);
        }
    }

    Program getProgram(Address addr) {
        for (ProgramInfo pi : this.openPrograms) {
            if (!pi.program.getMemory().contains(addr)) continue;
            return pi.program;
        }
        return null;
    }

    void saveLocation() {
        NavigationHistoryService historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        if (historyService == null) {
            return;
        }
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        if (gotoService == null) {
            return;
        }
        Navigatable defaultNavigatable = gotoService.getDefaultNavigatable();
        if (defaultNavigatable == null || defaultNavigatable.getProgram() == null) {
            return;
        }
        historyService.addNewLocation(defaultNavigatable);
    }

    private void setCurrentProgram(ProgramInfo info) {
        Program newProgram;
        if (this.currentInfo == info) {
            return;
        }
        Program program = newProgram = info == null ? null : info.program;
        if (this.currentInfo != null) {
            this.currentInfo.lastState = this.tool.getTransientState();
            this.tool.setSubTitle("");
            this.txMonitor.setProgram(null);
        }
        this.currentInfo = info;
        TransientToolState toolState = null;
        if (this.currentInfo != null) {
            this.currentInfo.setVisible(true);
            this.tool.setSubTitle(this.currentInfo.toString());
            this.txMonitor.setProgram(this.currentInfo.program);
            if (this.currentInfo.lastState != null) {
                toolState = this.currentInfo.lastState;
            }
        }
        this.fireActivatedEvent(newProgram);
        if (toolState != null) {
            toolState.restoreTool();
        }
        if (newProgram != null) {
            this.firePostActivatedEvent(newProgram);
        }
    }

    private void fireOpenEvents(Program program) {
        this.plugin.firePluginEvent(new ProgramOpenedPluginEvent(this.pluginName, program));
        this.plugin.firePluginEvent(new OpenProgramPluginEvent(this.pluginName, program));
    }

    private void fireCloseEvents(Program program) {
        this.plugin.firePluginEvent(new ProgramClosedPluginEvent(this.pluginName, program));
        this.plugin.firePluginEvent(new CloseProgramPluginEvent(this.pluginName, program, true));
    }

    private void fireActivatedEvent(Program newProgram) {
        this.plugin.firePluginEvent(new ProgramActivatedPluginEvent(this.pluginName, newProgram));
    }

    private void firePostActivatedEvent(Program newProgram) {
        this.plugin.firePluginEvent(new ProgramPostActivatedPluginEvent(this.pluginName, newProgram));
    }

    private void fireVisibilityChangeEvent(Program program, boolean isVisible) {
        this.plugin.firePluginEvent(new ProgramVisibilityChangePluginEvent(this.pluginName, program, isVisible));
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (!(ev.getSource() instanceof Program)) {
            return;
        }
        Program program = (Program)ev.getSource();
        if (ev.containsEvent(2) || ev.containsEvent(8)) {
            for (int i = 0; i < ev.numRecords(); ++i) {
                DomainObjectChangeRecord docr = ev.getChangeRecord(i);
                int eventType = docr.getEventType();
                if (eventType == 2) {
                    ProgramInfo info = this.getInfo(program);
                    if (info != null) {
                        info.programSavedAs();
                    }
                    if (this.currentInfo == null || this.currentInfo.program != program) continue;
                    String name = program.getDomainFile().toString();
                    this.tool.setSubTitle(name);
                    continue;
                }
                if (eventType != 8) continue;
                Throwable t = (Throwable)docr.getNewValue();
                String msg = t instanceof NoSuchObjectException ? program.getName() + " was closed due to an unrecoverable error!\nThis error could be the result of your computer becoming suspended\nor sleeping allowing the network connection with the Ghidra Server\nto fail." : program.getName() + " was closed due to an unrecoverable error!\n \nSuch failures are generally due to an IO Error caused\nby the local filesystem or server.";
                Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Severe Error Condition", (Object)msg);
                this.removeProgram(program);
                return;
            }
        }
    }

    public boolean isEmpty() {
        return this.openPrograms.isEmpty();
    }

    public boolean contains(Program p) {
        if (p == null) {
            return false;
        }
        return this.programMap.containsKey(p);
    }

    boolean isVisible(Program p) {
        ProgramInfo info = this.getInfo(p);
        return info != null ? info.visible : false;
    }

    void releaseProgram(Program program, Object owner) {
        ProgramInfo info = this.getInfo(program);
        if (info != null && info.owner == owner) {
            info.owner = null;
            if (!info.visible) {
                if (program.isChanged()) {
                    info.setVisible(true);
                }
                this.plugin.closeProgram(program, false);
            } else if (program.isTemporary()) {
                this.plugin.closeProgram(program, false);
            }
        }
    }

    boolean setPersistentOwner(Program program, Object owner) {
        ProgramInfo info = this.getInfo(program);
        if (info != null && info.owner == null) {
            info.owner = owner;
            return true;
        }
        return false;
    }

    boolean isPersistent(Program p) {
        ProgramInfo info = this.getInfo(p);
        return info != null && info.owner != null;
    }

    ProgramInfo getInfo(Program p) {
        if (p == null) {
            return null;
        }
        return this.programMap.get(p);
    }

    Program getOpenProgram(URL ghidraURL) {
        URL normalizedURL = GhidraURL.getNormalizedURL((URL)ghidraURL);
        for (ProgramInfo info : this.programMap.values()) {
            URL url = info.ghidraURL;
            if (url == null || !url.equals(normalizedURL)) continue;
            return info.program;
        }
        return null;
    }

    Program getOpenProgram(DomainFile domainFile, int version) {
        for (ProgramInfo info : this.programMap.values()) {
            DomainFile df = info.domainFile;
            if (df == null || !this.filesMatch(domainFile, version, df)) continue;
            return info.program;
        }
        return null;
    }

    private boolean filesMatch(DomainFile file1, int version, DomainFile file2) {
        if (!file1.getPathname().equals(file2.getPathname())) {
            return false;
        }
        if (file1.isCheckedOut() != file2.isCheckedOut()) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)file1.getProjectLocator(), (Object)file2.getProjectLocator())) {
            return false;
        }
        int openVersion = file2.isReadOnly() ? file2.getVersion() : -1;
        return version == openVersion;
    }

    boolean hasUnsavedPrograms() {
        return this.hasUnsavedPrograms;
    }

    private boolean checkForUnsavedPrograms() {
        Program currentProgram = this.getCurrentProgram();
        if (currentProgram != null && currentProgram.isChanged()) {
            return true;
        }
        for (ProgramInfo programInfo : this.openPrograms) {
            if (!programInfo.program.isChanged()) continue;
            return true;
        }
        return false;
    }

    public void transactionEnded(DomainObjectAdapterDB domainObj) {
    }

    public void transactionStarted(DomainObjectAdapterDB domainObj, TransactionInfo tx) {
    }

    public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
    }

    public void undoStackChanged(DomainObjectAdapterDB domainObj) {
        Swing.runLater((Runnable)this.programChangedRunnable);
    }

    private class MyFolderListener
    extends DomainFolderListenerAdapter {
        private MyFolderListener() {
        }

        public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
            if (!MultiProgramManager.this.programMap.containsKey(oldObject)) {
                return;
            }
            Element dataState = null;
            if (MultiProgramManager.this.currentInfo != null && MultiProgramManager.this.currentInfo.program == oldObject) {
                dataState = MultiProgramManager.this.tool.saveDataStateToXml(true);
            }
            OpenProgramTask openTask = new OpenProgramTask(file, -1, (Object)this);
            openTask.setSilent();
            new TaskLauncher((Task)openTask, (Component)MultiProgramManager.this.tool.getToolFrame());
            OpenProgramTask.OpenProgramRequest openProgramReq = openTask.getOpenProgram();
            if (openProgramReq != null) {
                MultiProgramManager.this.plugin.openProgram(openProgramReq.getProgram(), dataState != null ? 1 : 2);
                openProgramReq.release();
                MultiProgramManager.this.removeProgram((Program)oldObject);
                if (dataState != null) {
                    MultiProgramManager.this.tool.restoreDataStateFromXml(dataState);
                }
            }
        }
    }

    class ProgramInfo
    implements Comparable<ProgramInfo> {
        private static final AtomicInteger nextAvailableId = new AtomicInteger();
        public final Program program;
        private DomainFile domainFile;
        private URL ghidraURL;
        private TransientToolState lastState;
        private int instance;
        private boolean visible = false;
        private Object owner;
        private String str;

        ProgramInfo(Program p, DomainFile domainFile, boolean visible) {
            this.program = p;
            this.domainFile = domainFile;
            if (domainFile instanceof LinkedDomainFile) {
                LinkedDomainFile linkedDomainFile = (LinkedDomainFile)domainFile;
                this.ghidraURL = linkedDomainFile.getSharedProjectURL();
            } else {
                this.ghidraURL = null;
            }
            this.visible = visible;
            this.instance = nextAvailableId.incrementAndGet();
        }

        ProgramInfo(Program p, URL ghidraURL, boolean visible) {
            this.program = p;
            this.domainFile = null;
            this.ghidraURL = ghidraURL;
            this.visible = visible;
            this.instance = nextAvailableId.incrementAndGet();
        }

        URL getGhidraUrl() {
            return this.ghidraURL;
        }

        DomainFile getDomainFile() {
            return this.domainFile;
        }

        void programSavedAs() {
            this.domainFile = this.program.getDomainFile();
            this.ghidraURL = null;
            this.str = null;
        }

        public void setVisible(boolean state) {
            this.visible = state;
            MultiProgramManager.this.fireVisibilityChangeEvent(this.program, this.visible);
        }

        @Override
        public int compareTo(ProgramInfo info) {
            return this.instance - info.instance;
        }

        public String toString() {
            if (this.str != null) {
                return this.str;
            }
            StringBuilder buf = new StringBuilder();
            DomainFile df = this.program.getDomainFile();
            if (this.domainFile != null && this.domainFile.isLinkFile()) {
                buf.append(this.domainFile.getName());
                buf.append("->");
            }
            buf.append(df.toString());
            if (df.isReadOnly()) {
                buf.append(" [Read-Only]");
            }
            this.str = buf.toString();
            return this.str;
        }
    }
}

