/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.ActionContext;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramVisibilityChangePluginEvent;
import ghidra.app.plugin.core.progmgr.MultiTabPanel;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import javax.swing.Timer;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Open/close programs", description="This plugin provides actions for opening and closing multiple programs. A tab is displayed in the Code Browser when there is more than one open program", servicesRequired={ProgramManager.class, CodeViewerService.class}, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramVisibilityChangePluginEvent.class})
public class MultiTabPlugin
extends Plugin
implements DomainObjectListener {
    private final KeyStroke NEXT_TAB_KEYSTROKE = KeyStroke.getKeyStroke(120, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private final KeyStroke PREVIOUS_TAB_KEYSTROKE = KeyStroke.getKeyStroke(119, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private MultiTabPanel tabPanel;
    private ProgramManager progService;
    private CodeViewerService cvService;
    private DockingAction goToProgramAction;
    private DockingAction goToLastActiveProgramAction;
    private Program lastActiveProgram;
    private Program currentProgram;
    private DockingAction goToNextProgramAction;
    private DockingAction goToPreviousProgramAction;
    private Timer selectHighlightedProgramTimer;

    public MultiTabPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        String firstGroup = "1";
        String secondGroup = "2";
        this.goToProgramAction = new DockingAction("Go To Program", this.getName()){

            public void actionPerformed(ActionContext context) {
                MultiTabPlugin.this.showProgramList();
            }
        };
        this.goToProgramAction.setMenuBarData(new MenuData(new String[]{"&Navigation", "Go To Program..."}, null, "GoToWindow", -1, firstGroup));
        this.goToProgramAction.setKeyBindingData(new KeyBindingData(118, 128));
        this.goToProgramAction.setEnabled(false);
        this.goToProgramAction.setDescription("Shows the program selection dialog with the current program selected");
        this.goToProgramAction.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Go_To_Program"));
        this.goToNextProgramAction = new DockingAction("Go To Next Program", this.getName()){

            public void actionPerformed(ActionContext context) {
                MultiTabPlugin.this.nextProgramPressed();
            }
        };
        this.goToNextProgramAction.setEnabled(false);
        this.goToNextProgramAction.setDescription("Highlights the next program tab and then switches to that program");
        this.goToNextProgramAction.setKeyBindingData(new KeyBindingData(this.NEXT_TAB_KEYSTROKE));
        this.goToNextProgramAction.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Go_To_Next_And_Previous_Program"));
        this.goToPreviousProgramAction = new DockingAction("Go To Previous Program", this.getName()){

            public void actionPerformed(ActionContext context) {
                MultiTabPlugin.this.previousProgramPressed();
            }
        };
        this.goToPreviousProgramAction.setEnabled(false);
        this.goToPreviousProgramAction.setKeyBindingData(new KeyBindingData(this.PREVIOUS_TAB_KEYSTROKE));
        this.goToPreviousProgramAction.setDescription("Highlights the previous program tab and then switches to that program");
        this.goToPreviousProgramAction.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Go_To_Next_And_Previous_Program"));
        this.selectHighlightedProgramTimer = new Timer(750, e -> this.selectHighlightedProgram());
        this.selectHighlightedProgramTimer.setRepeats(false);
        this.goToLastActiveProgramAction = new DockingAction("Go To Last Active Program", this.getName()){

            public void actionPerformed(ActionContext context) {
                MultiTabPlugin.this.switchToProgram(MultiTabPlugin.this.lastActiveProgram);
            }
        };
        this.goToLastActiveProgramAction.setMenuBarData(new MenuData(new String[]{"&Navigation", "Go To Last Active Program"}, null, "GoToWindow", -1, secondGroup));
        this.goToLastActiveProgramAction.setKeyBindingData(new KeyBindingData(117, 128));
        this.goToLastActiveProgramAction.setEnabled(false);
        this.goToLastActiveProgramAction.setDescription("Activates the last program used before the current program");
        this.goToLastActiveProgramAction.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Go_To_Last_Active_Program"));
        this.tool.addAction((DockingActionIf)this.goToProgramAction);
        this.tool.addAction((DockingActionIf)this.goToLastActiveProgramAction);
        this.tool.addAction((DockingActionIf)this.goToNextProgramAction);
        this.tool.addAction((DockingActionIf)this.goToPreviousProgramAction);
    }

    private void updateActionEnablement() {
        boolean enable = this.tabPanel.getTabCount() > 1;
        this.goToProgramAction.setEnabled(enable);
        this.goToNextProgramAction.setEnabled(enable);
        this.goToPreviousProgramAction.setEnabled(enable);
        enable = this.lastActiveProgram != null;
        this.goToLastActiveProgramAction.setEnabled(enable);
    }

    private void switchToProgram(Program program) {
        if (this.lastActiveProgram != null) {
            this.tabPanel.setSelectedProgram(this.lastActiveProgram);
        }
    }

    private void showProgramList() {
        this.tabPanel.showProgramList();
    }

    private void highlightNextProgram(boolean forwardDirection) {
        this.tabPanel.highlightNextProgram(forwardDirection);
    }

    private void selectHighlightedProgram() {
        this.tabPanel.selectHighlightedProgram();
    }

    String getStringUsedInList(Program program) {
        DomainFile df = program.getDomainFile();
        String changeIndicator = program.isChanged() ? "*" : "";
        String pathString = this.getShortPath(df);
        if (!df.isInWritableProject()) {
            return pathString + " [Read-Only]" + changeIndicator;
        }
        return pathString + changeIndicator;
    }

    private String getShortPath(DomainFile df) {
        Object pathString = df.toString();
        int length = ((String)pathString).length();
        if (length < 100) {
            return pathString;
        }
        String[] pathParts = ((String)pathString).split("/");
        if (pathParts.length == 2) {
            return pathString;
        }
        String projectName = df.getProjectLocator().getName();
        int parentFolderIndex = pathParts.length - 2;
        String parentName = pathParts[parentFolderIndex];
        String filename = df.getName();
        pathString = projectName + ":/.../" + parentName + "/" + filename;
        return pathString;
    }

    String getToolTip(Program program) {
        return this.getStringUsedInList(program);
    }

    String getName(Program program) {
        DomainFile df = program.getDomainFile();
        Object tabName = df.getName();
        if (df.isReadOnly()) {
            int version = df.getVersion();
            if (!df.canSave() && version != -1) {
                tabName = (String)tabName + "@" + version;
            }
            tabName = (String)tabName + " [Read-Only]";
        }
        return tabName;
    }

    void keyTypedFromListWindow(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
        if (stroke.equals(this.NEXT_TAB_KEYSTROKE)) {
            this.nextProgramPressed();
        } else if (stroke.equals(this.PREVIOUS_TAB_KEYSTROKE)) {
            this.previousProgramPressed();
        }
    }

    private void nextProgramPressed() {
        this.highlightNextProgram(true);
        this.selectHighlightedProgramTimer.restart();
    }

    private void previousProgramPressed() {
        this.highlightNextProgram(false);
        this.selectHighlightedProgramTimer.restart();
    }

    boolean isChanged(Object obj) {
        return ((Program)obj).isChanged();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.getSource() instanceof Program) {
            Program program = (Program)ev.getSource();
            this.tabPanel.refresh(program);
        }
    }

    protected void init() {
        this.tabPanel = new MultiTabPanel(this);
        this.progService = (ProgramManager)this.tool.getService(ProgramManager.class);
        this.cvService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        this.cvService.setNorthComponent(this.tabPanel);
    }

    boolean removeProgram(Program program) {
        return this.progService.closeProgram(program, false);
    }

    void programSelected(Program program) {
        if (program != this.progService.getCurrentProgram()) {
            this.progService.setCurrentProgram(program);
        }
    }

    private void add(Program prog) {
        if (this.progService.isVisible(prog)) {
            this.tabPanel.addProgram(prog);
            prog.removeListener((DomainObjectListener)this);
            prog.addListener((DomainObjectListener)this);
            this.updateActionEnablement();
        }
    }

    private void remove(Program prog) {
        prog.removeListener((DomainObjectListener)this);
        this.tabPanel.removeProgram(prog);
        this.updateActionEnablement();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            Program prog = ((ProgramOpenedPluginEvent)event).getProgram();
            this.add(prog);
        } else if (event instanceof ProgramClosedPluginEvent) {
            Program prog = ((ProgramClosedPluginEvent)event).getProgram();
            if (prog == this.lastActiveProgram) {
                this.lastActiveProgram = null;
            }
            if (prog == this.currentProgram) {
                this.currentProgram = null;
            }
            this.remove(prog);
        } else if (event instanceof ProgramActivatedPluginEvent) {
            Program prog = ((ProgramActivatedPluginEvent)event).getActiveProgram();
            this.lastActiveProgram = this.currentProgram;
            this.currentProgram = prog;
            if (prog != null) {
                this.add(prog);
                if (this.tabPanel.getSelectedProgram() != prog) {
                    this.tabPanel.setSelectedProgram(prog);
                    this.updateActionEnablement();
                }
            }
        } else if (event instanceof ProgramVisibilityChangePluginEvent) {
            Program prog = ((ProgramVisibilityChangePluginEvent)event).getProgram();
            if (this.progService.isVisible(prog)) {
                this.add(prog);
                if (this.progService.getCurrentProgram() != prog) {
                    this.currentProgram = prog;
                    this.tabPanel.setSelectedProgram(prog);
                    this.updateActionEnablement();
                }
            } else {
                this.remove(prog);
                this.add(prog);
            }
        }
    }

    protected void dispose() {
        this.selectHighlightedProgramTimer.stop();
        this.tabPanel.removeAll();
        this.cvService.setNorthComponent(null);
    }
}

